/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.roads;

import java.text.DecimalFormat;
import org.postgis.Geometry;
import org.postgis.Point;
import ru.blok.cartography.GeoUtils;
import ru.blok.cartography.roads.OKBuildButton;
import ru.infor.beanviewer.annotation.ActionViewer;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.ws.objects.cartography.entities.Way;

@ListView(views={@View(title="\u041f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u0435 \u043f\u0438\u043a\u0435\u0442\u0430\u0436\u0430 \u0434\u043e\u0440\u043e\u0433\u0438", actions={@ActionViewer(clazz=OKBuildButton.class)}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class BuildStationingForm {
    String name;
    String length;
    Double lengthKM = 0.0;
    Integer fromBegin = 1;
    Integer fromNum = 1;
    Double indent = 0.0;
    Way way;
    Point[] points = null;

    public BuildStationingForm(Way way) {
        Geometry p = GeoUtils.buildGeometryFromString(way.getGeom());
        if (p != null) {
            this.setLengthKM(GeoUtils.buildLengthFromGeometry(p));
            this.setLength(new DecimalFormat("######.##").format(this.getLengthKM()));
            this.setPoints(GeoUtils.getAllPoints(p));
        }
        this.setName(way.getName());
        this.setWay(way);
    }

    @ListField(fields={@Field(title="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0440\u043e\u0433\u0438", order=100, readOnly=true, propertiesLayout="0/wrap 1/# cell 1 0, w 200# cell 0 0")})
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ListField(fields={@Field(title="\u0414\u043b\u0438\u043d\u0430 \u0434\u043e\u0440\u043e\u0433\u0438 (\u043a\u043c)", order=200, readOnly=true, propertiesLayout="0/wrap 1/# cell 1 1, w 200# cell 0 1")})
    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public Integer getFromBegin() {
        return this.fromBegin;
    }

    public void setFromBegin(Integer fromBegin) {
        this.fromBegin = fromBegin;
    }

    @ListField(fields={@Field(title="\u041d\u043e\u043c\u0435\u0440 \u043f\u0438\u043a\u0435\u0442\u0430 \u0441 ", order=400, propertiesLayout="0/wrap 1/# cell 1 3, w 200# cell 0 3")})
    public Integer getFromNum() {
        return this.fromNum;
    }

    public void setFromNum(Integer fromNum) {
        this.fromNum = fromNum;
    }

    @ListField(fields={@Field(title="\u041e\u0442\u0441\u0442\u0443\u043f \u043e\u0442 \u043d\u0430\u0447\u0430\u043b\u0430 (\u043c)", order=500, propertiesLayout="0/wrap 1/# cell 1 4, w 200# cell 0 4")})
    public Double getIndent() {
        return this.indent;
    }

    public void setIndent(Double indent) {
        this.indent = indent;
    }

    public Way getWay() {
        return this.way;
    }

    public void setWay(Way way) {
        this.way = way;
    }

    public Point[] getPoints() {
        return this.points;
    }

    public void setPoints(Point[] points) {
        this.points = points;
    }

    public Double getLengthKM() {
        return this.lengthKM;
    }

    public void setLengthKM(Double lengthKM) {
        this.lengthKM = lengthKM;
    }
}

