/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.roads;

import java.util.ArrayList;
import org.geotools.referencing.GeodeticCalculator;
import org.postgis.Point;
import ru.blok.cartography.roads.BuildStationingForm;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.OkWithoutSave;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.cartography.StationingWSProxy;
import ru.infor.ws.objects.cartography.entities.Stationing;
import ru.infor.ws.objects.cartography.entities.Way;

public class OKBuildButton
extends OkWithoutSave {
    GeodeticCalculator gc = new GeodeticCalculator();
    static Double oneKM = 1000.0;
    static Double zero = 0.0;

    public void actionPerformed(Object message) {
        Point[] points;
        ((PanelContext)this.getContext()).getPanel().updateMainObject();
        BuildStationingForm form = (BuildStationingForm)((PanelContext)this.getContext()).getPanel().getObject();
        if (form.getLengthKM().compareTo(form.getIndent() / 1000.0) < 1) {
            InitializedVariable.factory.runMessageEx((Object)new ErrorMessage("\u041e\u0442\u0441\u0442\u0443\u043f \u0431\u043e\u043b\u044c\u0448\u0435 \u0434\u043b\u0438\u043d\u044b \u0434\u043e\u0440\u043e\u0433\u0438!"), new BeanViewerAction[]{new MessageOKButton()});
            this.close();
        }
        if ((points = form.getPoints()) != null && points.length > 0) {
            Way w = form.getWay();
            ArrayList<Stationing> ls = new ArrayList<Stationing>();
            Integer num = form.getFromNum();
            Double indent = form.getIndent();
            if (indent.compareTo(zero) == 0) {
                Stationing s = this.addStationing(points[0].getX(), points[0].getY(), w, num);
                ls.add(s);
                num = num + 1;
                indent = oneKM;
            }
            int k0 = 0;
            block0: do {
                Double mi = zero;
                Double last = zero;
                boolean find = false;
                int i = k0 + 1;
                while (i < points.length) {
                    this.gc.setStartingGeographicPoint(points[i - 1].getX(), points[i - 1].getY());
                    this.gc.setDestinationGeographicPoint(points[i].getX(), points[i].getY());
                    last = this.gc.getOrthodromicDistance();
                    mi = mi + last;
                    if (mi > indent) {
                        k0 = i;
                        find = true;
                        break;
                    }
                    ++i;
                }
                if (!find) break;
                indent = mi - indent;
                Double lenv = Math.sqrt((points[k0].getX() - points[k0 - 1].getX()) * (points[k0].getX() - points[k0 - 1].getX()) + (points[k0].getY() - points[k0 - 1].getY()) * (points[k0].getY() - points[k0 - 1].getY()));
                do {
                    Double indentV = indent * lenv / last;
                    Double x = points[k0].getX() - indentV * (points[k0].getX() - points[k0 - 1].getX()) / lenv;
                    Double y = points[k0].getY() - indentV * (points[k0].getY() - points[k0 - 1].getY()) / lenv;
                    Stationing s = this.addStationing(x, y, w, num);
                    ls.add(s);
                    num = num + 1;
                    if (indent.compareTo(oneKM) >= 0) continue;
                    indent = oneKM - indent;
                    continue block0;
                } while ((indent = Double.valueOf(indent - oneKM)).compareTo(zero) > 0);
            } while (k0 > 0);
            StationingWSProxy proxy = (StationingWSProxy)CurrentProxyFactory.getProxy(Stationing.class);
            int i = 0;
            while (i < ls.size()) {
                proxy.save(InitializedVariable.context, (Stationing)ls.get(i));
                ++i;
            }
            ((PanelContext)((ViewerContext)((PanelContext)this.getContext()).getParentContext()).getParentContext()).getPanel().updateUI();
        }
        this.close();
    }

    private Stationing addStationing(Double x, Double y, Way w, Integer num) {
        Stationing s = new Stationing();
        s.setWay(w);
        s.setNum(num);
        s.setLat(y);
        s.setLon(x);
        return s;
    }
}

