/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.roads;

import java.util.List;
import ru.blok.cartography.common.AccepterButton;
import ru.blok.cartography.common.EditorObjectInJosm;
import ru.blok.cartography.roads.StationingRoad;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.ExtractorSearchCrteria;
import ru.blok.common.ui.buttons.AdderButtonInAsyncList;
import ru.blok.common.ui.buttons.EditorButtonInAsyncList;
import ru.blok.common.ui.buttons.RemoverButtonInAsyncList;
import ru.blok.common.ui.buttons.SearchButton;
import ru.blok.common.ui.list.ObjectUIList;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Check;
import ru.infor.beanviewer.annotation.ClassView;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.BigContentViewer;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.MapEntryKeyFilter;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.MapEntryKeyValue;
import ru.infor.ws.objects.cartography.entities.Way;

@ListView(views={@View(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0440\u043e\u0433", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RoadList {
    List<Way> ways;
    WayWSProxy wsProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
    WaySearchCriteria sc;

    public RoadList() {
        this.ways = new ObjectUIList(Way.class);
        this.sc = (WaySearchCriteria)((ObjectUIList)this.ways).getSearchCriteria();
        MapEntryKeyValue mekv = new MapEntryKeyValue();
        mekv.setKey("highway");
        MapEntryKeyFilter mek = new MapEntryKeyFilter();
        mek.setValues(new MapEntryKeyValue[]{mekv});
        this.sc.setKeyFilter(new MapEntryKeyFilter[]{mek});
        this.sc.setHaveTags(Integer.valueOf(1));
    }

    @ListField(fields={@Field(title="\u0414\u043e\u0440\u043e\u0433\u0438", order=100, propertiesField={"keyContentView=road"}, propertiesLayout="Split1/h/l/0.25", content=Way.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=AdderButtonInAsyncList.class, keyView="road", checks={@Check(checkId="WayWS:save")}), @ActionField(clazz=EditorButtonInAsyncList.class, doubleclick=true, keyView="road", checks={@Check(checkId="WayWS:save")}), @ActionField(clazz=RemoverButtonInAsyncList.class, checks={@Check(checkId="WayWS:delete")}), @ActionField(clazz=EditorObjectInJosm.class, checks={@Check(checkId="WayWS:save")}), @ActionField(clazz=AccepterButton.class, checks={@Check(checkId="WayWS:acceptEntries")}), @ActionField(clazz=StationingBtn.class), @ActionField(clazz=SearchButton.class)}), @PanelField(name="\u0424\u0438\u043b\u044c\u0442\u0440", order=30, classView={@ClassView(name="sc", clazz=WaySearchCriteria.class, extractor=ExtractorSearchCrteria.class)})})})
    public List<Way> getWays() {
        return this.ways;
    }

    public void setWays(List<Way> ways) {
        this.ways = ways;
    }

    public Way createWays() {
        Way w = new Way();
        Tag t = new Tag();
        t.setKey("highway");
        w.setTags(new Tag[]{t});
        return w;
    }

    public Way editWays(Way way) {
        return this.wsProxy.getCurrentObject(InitializedVariable.context, way.getId());
    }

    public void removeWays(Way way) {
        this.wsProxy.delete(InitializedVariable.context, way.getId());
    }

    public static class StationingBtn
    extends BeanViewerAction<ViewerContext> {
        public String getName() {
            return "\u041f\u0438\u043a\u0435\u0442\u0430\u0436 \u0434\u043e\u0440\u043e\u0433\u0438";
        }

        public boolean isNotEnableWithEmptySelection() {
            return true;
        }

        public void actionPerformed(Object message) {
            BigContentViewer bg = (BigContentViewer)((ViewerContext)this.getContext()).getPresentator().getViewer();
            List l = bg.getSelectedItems();
            if (l != null && l.size() > 0) {
                Way w = (Way)l.get(0);
                StationingRoad str = new StationingRoad(w);
                InitializedVariable.factory.newPage(str.getClass(), str.getClass(), (Object)str, (ViewerContext)this.getContext());
            }
        }
    }
}

