/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.routes;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.cartography.mapviewer.MapViewer;
import ru.blok.cartography.routes.MapValueRoute;
import ru.blok.cartography.routes.RoutePainter;
import ru.blok.cartography.routes.RouteShower;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.action.PanelContext;

public class MapViewerRoute
extends MapViewer {
    RoutePainter<JXMapViewer> routePainter;

    public MapViewerRoute(UIFactory<JComponent> factory) {
        super(factory);
    }

    @Override
    protected void init() {
        super.init();
        this.map.getMainMap().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point2D.Double pClick;
                Integer i;
                double x = MapViewerRoute.this.map.getMainMap().getCenter().getX() + e.getPoint().getX() - (double)(MapViewerRoute.this.map.getMainMap().getWidth() / 2);
                double y = MapViewerRoute.this.map.getMainMap().getCenter().getY() + e.getPoint().getY() - (double)(MapViewerRoute.this.map.getMainMap().getHeight() / 2);
                GeoPosition gp = MapViewerRoute.this.map.getMainMap().getTileFactory().pixelToGeo((Point2D)new Point2D.Double(x, y), MapViewerRoute.this.map.getMainMap().getZoom());
                if (e.getClickCount() == 1 && e.isControlDown()) {
                    MapValueRoute valueRoute = (MapValueRoute)MapViewerRoute.this.getValue();
                    if (valueRoute.getP1() == null) {
                        valueRoute.setP1(gp);
                    } else if (valueRoute.getP2() == null) {
                        valueRoute.setP2(gp);
                    } else {
                        valueRoute.setP1(valueRoute.getP2());
                        valueRoute.setP2(gp);
                    }
                    MapViewerRoute.this.map.repaint();
                } else if (e.getClickCount() == 1 && (i = MapViewerRoute.this.routePainter.include(pClick = new Point2D.Double(x, y))) != null && i > 0) {
                    ((MapValueRoute)((MapViewerRoute)MapViewerRoute.this).value).select = i;
                    Object tt = ((PanelContext)MapViewerRoute.this.getViewerContext().getParentContext()).getObject();
                    if (tt instanceof RouteShower) {
                        ((RouteShower)((Object)tt)).changeSelect((PanelContext)MapViewerRoute.this.getViewerContext().getParentContext(), false);
                    }
                }
            }
        });
    }

    @Override
    protected void initPainters() {
        super.initPainters();
        this.routePainter = new RoutePainter();
        this.painter.addPainter(this.routePainter);
    }

    @Override
    public void initMap() {
        if (this.getValue() == null) {
            this.value = new MapValueRoute(this.coord[0], this.coord[1], this.coord[2].intValue());
        }
        super.initMap();
    }

    @Override
    public void setValue(Object arg0) {
        MapValueRoute v = arg0 == null ? new MapValueRoute(this.coord[0], this.coord[1], this.coord[2].intValue()) : (MapValueRoute)arg0;
        super.setValue(v);
        this.routePainter.setValue(v);
    }
}

