/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.routes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.mapviewer.painter.MapViewPainter;
import ru.blok.cartography.routes.MapValueRoute;
import ru.infor.ws.objects.cartography.entities.Node;

public class RoutePainter<T extends JXMapViewer>
extends MapViewPainter<T> {
    HashMap<Integer, Polygon> lp = new HashMap();
    MapValueRoute value;

    @Override
    public void doPaint(Graphics2D g, T map, int width, int height) {
        Rectangle viewportBounds = map.getViewportBounds();
        int zoom = map.getZoom();
        Dimension sizeInTiles = map.getTileFactory().getMapSize(zoom);
        int tileSize = map.getTileFactory().getTileSize(zoom);
        Dimension sizeInPixels = new Dimension(sizeInTiles.width * tileSize, sizeInTiles.height * tileSize);
        double vpx = viewportBounds.getX();
        while (vpx < 0.0) {
            vpx += sizeInPixels.getWidth();
        }
        while (vpx > sizeInPixels.getWidth()) {
            vpx -= sizeInPixels.getWidth();
        }
        Rectangle2D.Double vp2 = new Rectangle2D.Double(vpx, viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        Rectangle2D.Double vp3 = new Rectangle2D.Double(vpx - sizeInPixels.getWidth(), viewportBounds.getY(), viewportBounds.getWidth(), viewportBounds.getHeight());
        this.paintRoute(map, g, vp2, vp3);
    }

    public Integer include(Point2D pClick) {
        if (this.lp != null) {
            for (Integer i : this.lp.keySet()) {
                Polygon p = this.lp.get(i);
                if (p == null || !p.contains(pClick)) continue;
                return i;
            }
        }
        return null;
    }

    protected void paintRoute(T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3) {
        Point2D point;
        Double angle;
        this.lp.clear();
        if (this.value.getRoute() != null && this.value.getRoute().length > 0) {
            g.setColor(Color.RED);
            Node n = this.value.getRoute()[0].getNode();
            Point2D pointFrom = map.getTileFactory().geoToPixel(new GeoPosition(n.getLat(), n.getLon()), map.getZoom());
            int i = 1;
            while (i < this.value.getRoute().length) {
                Node n1 = this.value.getRoute()[i].getNode();
                Point2D pointTo = map.getTileFactory().geoToPixel(new GeoPosition(n1.getLat(), n1.getLon()), map.getZoom());
                boolean s = this.value.getSelect() != null && i - 1 == this.value.getSelect();
                angle = null;
                if (s) {
                    angle = RoutePainter.getAngle(n, n1);
                }
                this.lp.put(i - 1, this.paintL(pointFrom, pointTo, map, g, vp2, vp3, s, angle));
                pointFrom = pointTo;
                n = n1;
                ++i;
            }
        }
        g.setColor(Color.RED);
        if (this.value.getP1() != null && vp2.contains(point = map.getTileFactory().geoToPixel(this.value.getP1(), map.getZoom()))) {
            g.fillOval((int)(point.getX() - vp2.getX()) - 4, (int)(point.getY() - vp2.getY()) - 4, 8, 8);
        }
        if (this.value.getP2() != null && vp2.contains(point = map.getTileFactory().geoToPixel(this.value.getP2(), map.getZoom()))) {
            g.fillOval((int)(point.getX() - vp2.getX()) - 4, (int)(point.getY() - vp2.getY()) - 4, 8, 8);
        }
        if (this.value.getSelect() != null) {
            int kfrom;
            int kto = kfrom = this.value.getSelect().intValue();
            if (kfrom < this.value.getRoute().length - 1) {
                kto = kfrom + 1;
            }
            Node nf = this.value.getRoute()[kfrom].getNode();
            Node nt = this.value.getRoute()[kto].getNode();
            Point2D pointF = map.getTileFactory().geoToPixel(new GeoPosition(nf.getLat(), nf.getLon()), map.getZoom());
            Point2D pointT = map.getTileFactory().geoToPixel(new GeoPosition(nt.getLat(), nt.getLon()), map.getZoom());
            angle = RoutePainter.getAngle(nf, nt);
            this.paintL(pointF, pointT, map, g, vp2, vp3, true, angle);
        }
    }

    public static Double getAngle(Node prev, Node last) {
        Double angle = null;
        Double len = Math.sqrt((last.getLon() - prev.getLon()) * (last.getLon() - prev.getLon()) + (last.getLat() - prev.getLat()) * (last.getLat() - prev.getLat()));
        if (len > 1.0E-10) {
            angle = Math.asin((last.getLat() - prev.getLat()) / len);
            angle = 90.0 - 180.0 * angle / Math.PI;
            if (last.getLon() - prev.getLon() > 0.0) {
                angle = 360.0 - angle;
            }
            angle = 360.0 - angle;
        }
        return angle;
    }

    protected void paintS(Graphics2D g, int x, int y, Double angle) {
        if (angle != null) {
            g.translate(x, y);
            g.rotate(Math.toRadians(angle + 180.0));
            Polygon p = new Polygon();
            p.addPoint(0, 8);
            p.addPoint(-3, 0);
            p.addPoint(0, 2);
            p.addPoint(3, 0);
            p.addPoint(0, 8);
            g.drawPolygon(p);
            g.fillPolygon(p);
            g.rotate(-Math.toRadians(angle + 180.0));
            g.translate(-x, -y);
        }
    }

    protected Polygon paintL(Point2D pointFrom, Point2D point, T map, Graphics2D g, Rectangle2D vp2, Rectangle2D vp3, boolean select, Double angle) {
        if (vp2.contains(point) || vp2.contains(pointFrom)) {
            if (select) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(this.value.getColor());
            }
            g.drawLine((int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), (int)(pointFrom.getX() - vp2.getX()), (int)(pointFrom.getY() - vp2.getY()));
            if (select) {
                this.paintS(g, (int)(point.getX() - vp2.getX()), (int)(point.getY() - vp2.getY()), angle);
            }
            Polygon p1 = new Polygon();
            p1.addPoint((int)(point.getX() - 5.0), (int)(point.getY() + 5.0));
            p1.addPoint((int)(point.getX() + 5.0), (int)(point.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() + 5.0), (int)(pointFrom.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() - 5.0), (int)(pointFrom.getY() + 5.0));
            return p1;
        }
        if (vp3.contains(point) || vp3.contains(pointFrom)) {
            if (select) {
                g.setColor(Color.BLUE);
            } else {
                g.setColor(this.value.getColor());
            }
            g.drawLine((int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), (int)(pointFrom.getX() - vp3.getX()), (int)(pointFrom.getY() - vp3.getY()));
            if (select) {
                this.paintS(g, (int)(point.getX() - vp3.getX()), (int)(point.getY() - vp3.getY()), angle);
            }
            Polygon p1 = new Polygon();
            p1.addPoint((int)(point.getX() - 5.0), (int)(point.getY() + 5.0));
            p1.addPoint((int)(point.getX() + 5.0), (int)(point.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() + 5.0), (int)(pointFrom.getY() - 5.0));
            p1.addPoint((int)(pointFrom.getX() - 5.0), (int)(pointFrom.getY() + 5.0));
            return p1;
        }
        return null;
    }

    @Override
    public void setValue(MapValue mapValueWithTrack) {
        this.value = (MapValueRoute)mapValueWithTrack;
    }
}

