/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.routes;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.geotools.referencing.GeodeticCalculator;
import ru.blok.cartography.core.ResourceStrings;
import ru.blok.cartography.routes.DirectoryListPresentationRoute;
import ru.blok.cartography.routes.MapValueRoute;
import ru.blok.cartography.routes.MapViewerRoute;
import ru.blok.cartography.routes.MoneDown;
import ru.blok.cartography.routes.MoveUp;
import ru.blok.cartography.routes.PathElementExt;
import ru.blok.cartography.routes.external.LoaderFromCloudmade;
import ru.blok.cartography.routes.external.LoaderFromMapQuest;
import ru.blok.cartography.routes.external.LoaderFromOSRM;
import ru.blok.common.core.CommonObjectWithKey;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.ui.buttons.AdderButton;
import ru.blok.common.ui.buttons.EditorButton;
import ru.blok.common.ui.buttons.RemoverButton;
import ru.blok.common.ui.directories.FRCBaseDirectoryViewer;
import ru.blok.common.ui.list.ObjectUIList;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.infor.beanviewer.annotation.ActionField;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.PanelField;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.core.ResourceString;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.dialog.ErrorMessage;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.client.soap.proxy.cartography.RouteRulesSetWSProxy;
import ru.infor.ws.objects.cartography.CalculateRouteParams;
import ru.infor.ws.objects.cartography.GPSPoint;
import ru.infor.ws.objects.cartography.PathElement;
import ru.infor.ws.objects.cartography.RouteRulesSetSearchCriteria;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.entities.BuildersRoutes;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.RouteRule;
import ru.infor.ws.objects.cartography.entities.RouteRulesSet;

@ListView(views={@View(title="\u0424\u043e\u0440\u043c\u0430 \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class RouteShower
extends CommonObjectWithKey {
    RouteRulesSet routeRulesSet;
    String nameRulesSet;
    BuildersRoutes buildersRoutes;
    String lengthKM;
    BeanViewerAction<ViewerContext> buildSelectRoute = new BeanViewerAction<ViewerContext>(){

        public String getHint() {
            return "\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442";
        }

        public String getIcon() {
            return ResourceStrings.btBuildRoute;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(Object message) {
            Node no;
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if (RouteShower.this.getBuildersRoutes() == null) {
                InitializedVariable.getFactory((String)RouteShower.this.getKeyPage()).runMessageEx((Object)new ErrorMessage("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430."), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            if (RouteShower.this.valueRoute.getP1() == null || RouteShower.this.valueRoute.getP2() == null) {
                InitializedVariable.getFactory((String)RouteShower.this.getKeyPage()).runMessageEx((Object)new ErrorMessage("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0438\u043b\u0438 \u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0442\u043e\u0447\u043a\u0438."), new BeanViewerAction[]{new MessageOKButton()});
                return;
            }
            GPSPoint from = new GPSPoint();
            from.setLat(Double.valueOf(RouteShower.this.valueRoute.getP1().getLatitude()));
            from.setLon(Double.valueOf(RouteShower.this.valueRoute.getP1().getLongitude()));
            GPSPoint to = new GPSPoint();
            to.setLat(Double.valueOf(RouteShower.this.valueRoute.getP2().getLatitude()));
            to.setLon(Double.valueOf(RouteShower.this.valueRoute.getP2().getLongitude()));
            BuildersRoutes br = RouteShower.this.getBuildersRoutes();
            PathElement[] pp = null;
            try {
                if (br.getCode().toLowerCase().indexOf("infor") > -1) {
                    Long routeRulesSetId = null;
                    if (RouteShower.this.getRouteRulesSet() == null) {
                        RouteRulesSetSearchCriteria sc = new RouteRulesSetSearchCriteria();
                        sc.setName("*\u041d\u0430\u0431\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e*");
                        RouteRulesSetWSProxy.SearchResultListRouteRulesSet sr = RouteShower.this.proxy.getList(InitializedVariable.getContext((String)RouteShower.this.getKeyPage()), sc);
                        if (sr.isEmpty()) {
                            InitializedVariable.getFactory((String)RouteShower.this.getKeyPage()).runMessageEx((Object)new ErrorMessage("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043d\u0430\u0431\u043e\u0440 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \n\u0438 \u043d\u0435\u0442 \u043d\u0430\u0431\u043e\u0440\u0430 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e."), new BeanViewerAction[]{new MessageOKButton()});
                            return;
                        }
                        routeRulesSetId = ((RouteRulesSet)sr.getObjList()[0]).getId();
                    } else {
                        routeRulesSetId = RouteShower.this.getRouteRulesSet().getId();
                    }
                    CalculateRouteParams p = new CalculateRouteParams();
                    p.setFrom(from);
                    p.setTo(to);
                    p.setRulesSetId(routeRulesSetId);
                    pp = RouteShower.this.proxy.calcRoute(InitializedVariable.getContext((String)RouteShower.this.getKeyPage()), p);
                }
                if (br.getCode().toLowerCase().indexOf("cloudmade") > -1) {
                    pp = LoaderFromCloudmade.getRoute(InitializedVariable.getContext((String)RouteShower.this.getKeyPage()), from, to, 1);
                }
                if (br.getCode().toLowerCase().indexOf("osrm") > -1) {
                    pp = LoaderFromOSRM.getRoute(InitializedVariable.getContext((String)RouteShower.this.getKeyPage()), from, to);
                }
                if (br.getCode().toLowerCase().indexOf("mapquest") > -1) {
                    pp = LoaderFromMapQuest.getRoute(InitializedVariable.getContext((String)RouteShower.this.getKeyPage()), from, to, 1, "Fmjtd%7Cluur2l6r21%2C7l%3Do5-90ywlf");
                }
            }
            catch (Exception exception) {}
            ArrayList<PathElement> listPE = new ArrayList<PathElement>();
            if (pp == null || pp.length == 0 || pp[0].getNode().getLat() != from.getLat().doubleValue() || pp[0].getNode().getLon() != from.getLon().doubleValue()) {
                PathElement pe = new PathElement();
                no = new Node();
                no.setLat(from.getLat().doubleValue());
                no.setLon(from.getLon().doubleValue());
                pe.setNode(no);
                listPE.add(pe);
            }
            if (pp != null && pp.length > 0) {
                int i = 0;
                while (i < pp.length) {
                    listPE.add(pp[i]);
                    ++i;
                }
            }
            if (pp == null || pp.length == 0 || pp[pp.length - 1].getNode().getLat() != to.getLat().doubleValue() || pp[pp.length - 1].getNode().getLon() != to.getLon().doubleValue()) {
                PathElement pe = new PathElement();
                no = new Node();
                no.setLat(to.getLat().doubleValue());
                no.setLon(to.getLon().doubleValue());
                pe.setNode(no);
                listPE.add(pe);
            }
            pp = listPE.toArray(new PathElement[listPE.size()]);
            RouteShower.this.calcLength(pp);
            RouteShower.this.valueRoute.setRoute(pp);
            RouteShower.this.valueRoute.setColor(new Color(br.getColor()));
            if (pp == null) {
                RouteShower.this.pe = null;
            } else {
                RouteShower.this.pe = new PathElementExt[pp.length];
                int i = 0;
                while (i < pp.length) {
                    RouteShower.this.pe[i] = new PathElementExt(i, pp[i]);
                    ++i;
                }
            }
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    BeanViewerAction<ViewerContext> selectN = new BeanViewerAction<ViewerContext>(){

        public String getIcon() {
            return ResourceString.btEditImage;
        }

        public void actionPerformed(Object message) {
            try {
                ObjectUIList lRouteRulesSet = new ObjectUIList(RouteRulesSet.class, RouteShower.this.getKeyPage());
                DirectoryListPresentationRoute dir = new DirectoryListPresentationRoute(RouteRulesSet.class, (List<?>)lRouteRulesSet, RouteShower.this.getKeyPage());
                InitializedVariable.getFactory((String)RouteShower.this.getKeyPage()).newPage(RouteRulesSet.class, DirectoryListPresentationRoute.class, (Object)dir, (ViewerContext)this.getContext());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    RouteRulesSetWSProxy proxy = (RouteRulesSetWSProxy)CurrentProxyFactory.getProxy(RouteRulesSet.class, (String)this.getKeyPage());
    BeanViewerAction<ViewerContext> saveR = new BeanViewerAction<ViewerContext>(){

        public String getIcon() {
            return ResourceString.btSaveImage;
        }

        public String getName() {
            return "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430\u0431\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b";
        }

        public void actionPerformed(Object message) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            RouteShower.this.saveRouteRules();
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }
    };
    private RouteRule[] list;
    MapValueRoute valueRoute;
    PathElementExt[] pe = new PathElementExt[0];
    Tag[] tagNodeFrom;
    Tag[] tagNodeTo;
    Tag[] tagLine;
    boolean changeSelect = false;

    @ListField(fields={@Field(title="\u041d\u0430\u0431\u043e\u0440 \u043f\u0440\u0430\u0432\u0438\u043b", order=0, propertiesLayout="Split1/h/l/0.25:1#split 3")})
    public String getNameRulesSet() {
        return this.nameRulesSet;
    }

    public void setNameRulesSet(String nameRulesSet) {
        this.nameRulesSet = nameRulesSet;
    }

    @ListField(fields={@Field(title="", order=5, propertiesLayout="Split1/h/l/0.25:1#wrap", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getSelectN() {
        return this.selectN;
    }

    @ListField(fields={@Field(title="\u0412\u044b\u0431\u043e\u0440 \u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044f", order=8, propertiesLayout="Split1/h/l/0.25:1/fillx//#w 300", viewer={FRCBaseDirectoryViewer.class})})
    public BuildersRoutes getBuildersRoutes() {
        return this.buildersRoutes;
    }

    public void setBuildersRoutes(BuildersRoutes buildersRoutes) {
        this.buildersRoutes = buildersRoutes;
    }

    @ListField(fields={@Field(title="", order=10, propertiesLayout="Split1/h/l/0.25:1#wrap", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getBuildSelectRoute() {
        return this.buildSelectRoute;
    }

    private void calcLength(PathElement[] pp) {
        double milage = 0.0;
        GeodeticCalculator gc = new GeodeticCalculator();
        int i = 1;
        while (i < pp.length) {
            gc.setStartingGeographicPoint(pp[i - 1].getNode().getLon(), pp[i - 1].getNode().getLat());
            gc.setDestinationGeographicPoint(pp[i].getNode().getLon(), pp[i].getNode().getLat());
            milage += gc.getOrthodromicDistance();
            ++i;
        }
        this.setLengthKM(new DecimalFormat("###0.00").format(milage / 1000.0));
        ((PanelContext)((ViewerContext)this.buildSelectRoute.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("lengthKM");
    }

    private boolean saveRouteRules() {
        if (this.nameRulesSet == null || "".equals(this.nameRulesSet)) {
            InitializedVariable.getFactory((String)this.getKeyPage()).runMessageEx((Object)new ErrorMessage("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u0439"), new BeanViewerAction[]{new MessageOKButton()});
        }
        RouteRulesSetSearchCriteria sc = (RouteRulesSetSearchCriteria)this.proxy._getSearchCriteriaTemplate();
        sc.setName(String.valueOf(this.getNameRulesSet()) + "*");
        RouteRulesSetWSProxy.SearchResultListRouteRulesSet l = this.proxy.getList(InitializedVariable.getContext((String)this.getKeyPage()), sc);
        RouteRulesSet r = l.isEmpty() ? new RouteRulesSet() : (RouteRulesSet)l.getObjList()[0];
        r.setName(this.getNameRulesSet());
        r.setRules(this.getList());
        r = this.proxy.save(InitializedVariable.getContext((String)this.getKeyPage()), r);
        r = this.proxy.getCurrentObject(InitializedVariable.getContext((String)this.getKeyPage()), r.getId());
        this.setRouteRulesSet(r);
        return true;
    }

    public RouteRulesSet getRouteRulesSet() {
        return this.routeRulesSet;
    }

    public void setRouteRulesSet(RouteRulesSet routeRulesSet) {
        this.routeRulesSet = routeRulesSet;
        this.nameRulesSet = routeRulesSet.getName();
        this.list = routeRulesSet.getRules();
    }

    public RouteShower(String keyPage) {
        super(keyPage);
        Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.getWorkplaceId((String)keyPage));
        this.valueRoute = new MapValueRoute(coord[0], coord[1], coord[2].intValue());
    }

    @ListField(fields={@Field(title="\u0414\u043b\u0438\u043d\u0430 (\u043a\u043c):", order=142, propertiesLayout="Split1/h/l/0.25:1", readOnly=true, propertiesUI={"background=#d4d0c8"})})
    public String getLengthKM() {
        return this.lengthKM;
    }

    public void setLengthKM(String lengthKM) {
        this.lengthKM = lengthKM;
    }

    @ListField(fields={@Field(title="\u041a\u0440\u0438\u0442\u0435\u0440\u0438\u0438 \u043f\u043e\u0438\u0441\u043a\u0430", order=20, propertiesLayout="Split1/h/l/0.25:2# grow, wrap,spanx 2#wrap,spanx 2", viewer={ListViewer.class}, content=RouteRule.class, panels={@PanelField(name="\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e", order=10, actions={@ActionField(clazz=AdderButton.class), @ActionField(clazz=EditorButton.class, doubleclick=true), @ActionField(clazz=RemoverButton.class), @ActionField(clazz=MoveUp.class), @ActionField(clazz=MoneDown.class)})})})
    public RouteRule[] getList() {
        return this.list;
    }

    public void setList(RouteRule[] list) {
        this.list = list;
    }

    @ListField(fields={@Field(title="", order=40, propertiesLayout="Split1/h/r/0.25", viewer={MapViewerRoute.class})})
    public MapValueRoute getValueRoute() {
        return this.valueRoute;
    }

    public void setValueRoute(MapValueRoute valueRoute) {
        this.valueRoute = valueRoute;
    }

    @ListField(fields={@Field(title="", order=50, propertiesLayout="Split1/h/l/0.25:2/fill#growx, wrap,spanx 2# wrap, spanx 2", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getSaveR() {
        return this.saveR;
    }

    @ListField(fields={@Field(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0442\u0440\u0435\u0437\u043a\u043e\u0432 \u043f\u0443\u0442\u0438", order=90, propertiesLayout="Split1/h/l/0.25:2# grow, wrap,spanx 2#wrap,spanx 2", viewer={ListViewerT.class}, content=PathElementExt.class)})
    public PathElementExt[] getPathElements() {
        return this.pe;
    }

    @ListField(fields={@Field(title="\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0442\u043e\u0447\u043a\u0438 \u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0442\u0440\u0435\u0437\u043a\u0430", order=100, propertiesLayout="Split1/h/l/0.25:2# grow, wrap,spanx 2#wrap,spanx 2", viewer={ListViewer.class}, content=Tag.class)})
    public Tag[] getTagNodeFrom() {
        return this.tagNodeFrom;
    }

    public void setTagNodeFrom(Tag[] tagNodeFrom) {
        this.tagNodeFrom = tagNodeFrom;
    }

    @ListField(fields={@Field(title="\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0442\u043e\u0447\u043a\u0438 \u043a\u043e\u043d\u0446\u0430 \u043e\u0442\u0440\u0435\u0437\u043a\u0430", order=110, propertiesLayout="Split1/h/l/0.25:2# grow, wrap,spanx 2#wrap,spanx 2", viewer={ListViewer.class}, content=Tag.class)})
    public Tag[] getTagNodeTo() {
        return this.tagNodeTo;
    }

    public void setTagNodeTo(Tag[] tagNodeTo) {
        this.tagNodeTo = tagNodeTo;
    }

    @ListField(fields={@Field(title="\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043b\u0438\u043d\u0438\u0438 \u043e\u0442\u0440\u0435\u0437\u043a\u0430", order=130, propertiesLayout="Split1/h/l/0.25:2# grow, wrap,spanx 2#wrap,spanx 2", viewer={ListViewer.class}, content=Tag.class)})
    public Tag[] getTagLine() {
        return this.tagLine;
    }

    public void setTagLine(Tag[] tagLine) {
        this.tagLine = tagLine;
    }

    public void changeSelect(PanelContext pc, boolean position) {
        this.changeSelect = true;
        Integer s = this.valueRoute.getSelect();
        pc.getPanel().updateMainObject();
        if (this.valueRoute.getSelect() == null || this.valueRoute.getSelect() < 0) {
            this.tagNodeFrom = null;
            this.tagNodeTo = null;
            this.tagLine = null;
        } else {
            this.tagNodeFrom = this.valueRoute.getRoute()[s].getNode().getTags();
            this.tagNodeTo = s < this.valueRoute.getRoute().length - 1 ? this.valueRoute.getRoute()[s + 1].getNode().getTags() : null;
            this.tagLine = this.valueRoute.getRoute()[s].getTags();
            if (position) {
                if (s != null) {
                    Node n = this.valueRoute.getRoute()[s].getNode();
                    this.valueRoute.setLat(n.getLat());
                    this.valueRoute.setLon(n.getLon());
                }
            } else {
                ((ListViewer)pc.getPanel().getPresentatorForName("pathElements").getViewer()).getTM().setSelectedRows(new int[]{s});
            }
        }
        pc.getPanel().updateUI();
        if (s != null) {
            ((ListViewer)pc.getPanel().getPresentatorForName("pathElements").getViewer()).getTM().setSelectedRows(new int[]{s});
        }
        this.changeSelect = false;
    }

    public static class ListViewerT<T>
    extends ListViewer<T> {
        public ListViewerT(UIFactory<T> factory) {
            super(factory);
            this.addActionOnSelect();
        }

        protected void actionOnSelect() {
            List l = this.getSelectedItems();
            RouteShower t = (RouteShower)((Object)((PanelContext)this.getViewerContext().getParentContext()).getObject());
            if (!t.changeSelect) {
                if (l != null && l.size() > 0) {
                    PathElementExt p = (PathElementExt)l.get(0);
                    t.getValueRoute().setSelect(p.getOrder());
                } else {
                    t.getValueRoute().setSelect(null);
                }
                t.changeSelect((PanelContext)this.getViewerContext().getParentContext(), true);
            }
        }
    }
}

