/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.routes.external;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import ru.blok.cartography.routes.external.KeyFinder;
import ru.blok.common.core.InitializedVariable;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.cartography.GPSPoint;
import ru.infor.ws.objects.cartography.PathElement;
import ru.infor.ws.objects.cartography.entities.Node;

public class LoaderFromCloudmade {
    static DecimalFormat coordFormat = new DecimalFormat("#0.############");

    public static PathElement[] getRoute(InvocationContext context, GPSPoint from, GPSPoint to, Integer fintessID) {
        HashMap sp = InitializedVariable.runtimeParameters((Long)InitializedVariable.workplaceId);
        String api_key = null;
        if (sp.get("ApiKeyForCloudmade") != null) {
            api_key = (String)sp.get("ApiKeyForCloudmade");
        }
        if (api_key == null) {
            InitializedVariable.factory.runMessageEx((Object)new WarningMessage("", new String[]{"\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 ApiKeyForCloudmade\n - API KEY \u0434\u043b\u044f \u0440\u0430\u0441\u0447\u0435\u0442\u043e\u0432 \u043f\u0443\u0442\u0438."}), new BeanViewerAction[]{new MessageOKButton()});
            return null;
        }
        Double fitness = 0.0;
        try {
            File tempFile = File.createTempFile("route", ".js");
            String pathTempFile = tempFile.getAbsolutePath();
            LoaderFromCloudmade.loadFileFromInternet(from, to, fintessID, pathTempFile, api_key);
            String rez = LoaderFromCloudmade.readFromFile(pathTempFile);
            JSONParser parser = new JSONParser();
            try {
                KeyFinder finder = new KeyFinder();
                finder.setMatchKey("total_distance");
                parser.parse(rez, (ContentHandler)finder, true);
                if (finder.isFound()) {
                    finder.setFound(false);
                    fitness = ((Long)finder.getValue()).doubleValue();
                }
                int p1 = rez.indexOf("\"route_geometry\":[[") + 18;
                int p2 = rez.indexOf("],\"route_instructions\"");
                String rz = rez.substring(p1, p2);
                int i = 0;
                int j = rz.indexOf("]");
                while (j > 0) {
                    j = rz.indexOf("]", j + 1);
                    ++i;
                }
                PathElement[] pp = new PathElement[i];
                i = 0;
                int ii = 0;
                j = rz.indexOf("]", 0);
                while (j > 0) {
                    String pr = rz.substring(i + 1, j);
                    int k = pr.indexOf(",");
                    PathElement pe = new PathElement();
                    Node no = new Node();
                    no.setLat(Double.valueOf(pr.substring(0, k)).doubleValue());
                    no.setLon(Double.valueOf(pr.substring(k + 1)).doubleValue());
                    pe.setNode(no);
                    pe.setWeight(fitness);
                    pp[ii] = pe;
                    ++ii;
                    i = j + 2;
                    j = rz.indexOf("]", j + 1);
                }
                try {
                    tempFile.delete();
                }
                catch (Exception exception) {}
                return pp;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readFromFile(String fileName) {
        String DataLine = "";
        try {
            File inFile = new File(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
            DataLine = br.readLine();
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return DataLine;
    }

    public static void loadFileFromInternet(GPSPoint from, GPSPoint to, Integer fintessID, String pathTempFile, String api_key) {
        FilterInputStream in = null;
        OutputStream fOut = null;
        String arg0 = "http://routes.cloudmade.com/" + api_key + "/api/0.3/";
        arg0 = String.valueOf(arg0) + coordFormat.format(from.getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(from.getLon()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(to.getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(to.getLon()).replaceAll(",", ".");
        arg0 = String.valueOf(arg0) + "/car/" + (Integer.valueOf(1).equals(fintessID) ? "shortest" : "fastest") + ".js?lang=ru";
        try {
            try {
                int data;
                URL remoteFile = new URL(arg0);
                URLConnection fileStream = InitializedVariable.getCurrentConnection((URL)remoteFile);
                fOut = new FileOutputStream(pathTempFile);
                new DataOutputStream(fOut);
                in = new DataInputStream(fileStream.getInputStream());
                while ((data = in.read()) != -1) {
                    ((FileOutputStream)fOut).write(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
                fOut.flush();
                ((FileOutputStream)fOut).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

