/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.routes.external;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import ru.blok.common.core.InitializedVariable;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.cartography.GPSPoint;
import ru.infor.ws.objects.cartography.PathElement;
import ru.infor.ws.objects.cartography.entities.Node;

public class LoaderFromMapQuest {
    static DecimalFormat coordFormat = new DecimalFormat("#0.############");

    public static PathElement[] getRoute(InvocationContext context, GPSPoint from, GPSPoint to, Integer fintessID, String api_key) {
        return LoaderFromMapQuest.getRouteWithPoints(context, from, to, fintessID, api_key, null);
    }

    public static PathElement[] getRouteWithPoints(InvocationContext context, GPSPoint from, GPSPoint to, Integer fintessID, String api_key, PathElement[] points) {
        Double fitness = 0.0;
        try {
            String rz;
            int p2;
            File tempFile = File.createTempFile("route", ".js");
            String pathTempFile = tempFile.getAbsolutePath();
            LoaderFromMapQuest.loadFileFromInternet(from, to, fintessID, pathTempFile, api_key, points);
            String rez = LoaderFromMapQuest.readFromFile(pathTempFile);
            int p1 = rez.indexOf("\"distance\":");
            if (p1 > 0 && (p2 = (rz = rez.substring(p1, rez.length() - p1)).indexOf(",")) > 0) {
                fitness = Double.valueOf(rz.substring(11, p2));
            }
            if ((p2 = (rz = rez.substring(p1 = rez.indexOf("\"shapePoints\":"), rez.length() - p1)).indexOf("]")) > 0) {
                rz = rz.substring(15, p2);
            }
            String[] st = rz.split(",");
            PathElement[] np = new PathElement[st.length / 2];
            int k = 0;
            while (k < st.length - 1) {
                PathElement pe = new PathElement();
                Node no = new Node();
                no.setLat(Double.valueOf(st[k]).doubleValue());
                no.setLon(Double.valueOf(st[k + 1]).doubleValue());
                pe.setNode(no);
                pe.setWeight(fitness);
                np[k / 2] = pe;
                ++k;
                ++k;
            }
            return np;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String readFromFile(String fileName) {
        String DataLine = "";
        try {
            File inFile = new File(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(inFile)));
            DataLine = br.readLine();
            br.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return DataLine;
    }

    public static void loadFileFromInternet(GPSPoint from, GPSPoint to, Integer fintessID, String pathTempFile, String api_key, PathElement[] points) {
        FilterInputStream in = null;
        OutputStream fOut = null;
        String arg0 = "http://open.mapquestapi.com/directions/v2/route?key=" + api_key + "&routeType=" + (Integer.valueOf(1).equals(fintessID) ? "shortest" : "fastest") + "&timeType=1" + "&enhancedNarrative=false" + "&shapeFormat=raw" + "&generalize=0" + "&locale=ru_Ru" + "&unit=k" + "&from=";
        arg0 = String.valueOf(arg0) + coordFormat.format(from.getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(from.getLon()).replaceAll(",", ".") + "&to=";
        if (points != null && points.length > 0) {
            int i = 0;
            while (i < points.length) {
                arg0 = String.valueOf(arg0) + coordFormat.format(points[i].getNode().getLat()).replaceAll(",", ".") + ",";
                arg0 = String.valueOf(arg0) + coordFormat.format(points[i].getNode().getLon()).replaceAll(",", ".") + "&to=";
                ++i;
            }
        }
        arg0 = String.valueOf(arg0) + coordFormat.format(to.getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(to.getLon()).replaceAll(",", ".");
        try {
            try {
                int data;
                URL remoteFile = new URL(arg0);
                URLConnection fileStream = InitializedVariable.getCurrentConnection((URL)remoteFile);
                fOut = new FileOutputStream(pathTempFile);
                new DataOutputStream(fOut);
                in = new DataInputStream(fileStream.getInputStream());
                while ((data = in.read()) != -1) {
                    ((FileOutputStream)fOut).write(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
                fOut.flush();
                ((FileOutputStream)fOut).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

