/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.routes.external;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import ru.blok.common.core.InitializedVariable;
import ru.infor.ws.objects.InvocationContext;
import ru.infor.ws.objects.cartography.GPSPoint;
import ru.infor.ws.objects.cartography.PathElement;
import ru.infor.ws.objects.cartography.entities.Node;

public class LoaderFromOSRM {
    static DecimalFormat coordFormat = new DecimalFormat("#0.############");
    public static List<PathElement> listP = new ArrayList<PathElement>();

    public static PathElement[] getRoute(InvocationContext context, GPSPoint from, GPSPoint to) {
        listP.clear();
        try {
            File tempFile = File.createTempFile("route", ".gpx");
            String pathTempFile = tempFile.getAbsolutePath();
            LoaderFromOSRM.loadFileFromInternet(from, to, pathTempFile);
            LoaderFromOSRM.parseFile(pathTempFile);
            return listP.toArray(new PathElement[listP.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void loadFileFromInternet(GPSPoint from, GPSPoint to, String pathTempFile) {
        FilterInputStream in = null;
        OutputStream fOut = null;
        String arg0 = "http://router.project-osrm.org/viaroute?loc=";
        arg0 = String.valueOf(arg0) + coordFormat.format(from.getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(from.getLon()).replaceAll(",", ".");
        arg0 = String.valueOf(arg0) + "&loc=";
        arg0 = String.valueOf(arg0) + coordFormat.format(to.getLat()).replaceAll(",", ".") + ",";
        arg0 = String.valueOf(arg0) + coordFormat.format(to.getLon()).replaceAll(",", ".");
        arg0 = String.valueOf(arg0) + "&output=gpx";
        try {
            try {
                int data;
                URL remoteFile = new URL(arg0);
                URLConnection fileStream = InitializedVariable.getCurrentConnection((URL)remoteFile);
                fOut = new FileOutputStream(pathTempFile);
                new DataOutputStream(fOut);
                in = new DataInputStream(fileStream.getInputStream());
                while ((data = in.read()) != -1) {
                    ((FileOutputStream)fOut).write(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
                fOut.flush();
                ((FileOutputStream)fOut).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
    }

    private static void parseFile(String pathTempFile) {
        try {
            int count;
            FileReader fr = new FileReader(pathTempFile);
            char[] chrs = new char[255];
            String st = "";
            do {
                count = fr.read(chrs);
                String st_ = new String(chrs);
                if (count < 255) {
                    st_ = st_.substring(0, count);
                }
                if (st_.indexOf("<rte>") > -1) {
                    st_ = st_.substring(st_.indexOf("<rte>") + 5);
                }
                st = st.concat(st_);
                st = LoaderFromOSRM.parseData(st);
            } while (count >= 255 && count != -1);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {}
    }

    private static String parseData(String st_) {
        if (st_.indexOf("<rtept") < 0) {
            return st_;
        }
        String[] h = st_.split("</rtept>");
        if (h.length == 1) {
            return st_;
        }
        int i = 0;
        while (i < h.length - 1) {
            String s1 = h[i].substring(h[i].indexOf("\"") + 1);
            String s2 = s1.substring(s1.indexOf("lon=") + 5);
            s1 = s1.substring(0, s1.indexOf("\""));
            s2 = s2.substring(0, s2.indexOf("\""));
            try {
                PathElement pe = new PathElement();
                Node no = new Node();
                no.setLat(Double.valueOf(s1).doubleValue());
                no.setLon(Double.valueOf(s2).doubleValue());
                pe.setNode(no);
                listP.add(pe);
            }
            catch (Exception exception) {}
            ++i;
        }
        return h[h.length - 1];
    }
}

