/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.search;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.viewer.GeoPosition;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.Point;
import org.postgis.Polygon;
import ru.blok.cartography.core.ResourceStrings;
import ru.blok.cartography.mapviewer.MapViewer;
import ru.blok.cartography.mapviewer.painter.IconOnMap;
import ru.blok.cartography.search.SearchLocationForm;
import ru.infor.beanviewer.core.UIFactory;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.AbstractContext;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.list.ListViewer;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;
import ru.infor.ws.objects.cartography.ext.GeoNode;

public class ListGeoNodeViewer<T>
extends ListViewer<T> {
    public ListGeoNodeViewer(UIFactory<T> factory) {
        super(factory);
        this.addActionOnSelectionListener(new BeanViewerAction<AbstractContext<?>>(){

            public void actionPerformed(Object message) {
                ListGeoNodeViewer.this.actionOnSelect();
            }
        });
    }

    protected void actionOnSelect() {
        super.actionOnSelect();
        List l = this.getSelectedItems();
        SearchLocationForm t = (SearchLocationForm)((PanelContext)this.getViewerContext().getParentContext()).getObject();
        if (l != null && l.size() > 0) {
            t.getValue().deleteAllIcons();
            t.getValue().setWays(null);
            ArrayList<Way> listW = new ArrayList<Way>();
            int jj = 0;
            while (jj < l.size()) {
                GeoNode o = (GeoNode)l.get(jj);
                if (o.isNode()) {
                    GeoPosition point = new GeoPosition(o.getLat(), o.getLon());
                    t.getValue().addIconOnMap(new IconOnMap(ResourceStrings.btFlag32, point));
                } else {
                    ArrayList<Node> lN = new ArrayList<Node>();
                    Polygon polygon = null;
                    if (o.getGeom().toLowerCase().indexOf("linestring") > -1) {
                        try {
                            LineString ls = new LineString(o.getGeom());
                            LinearRing lr = new LinearRing(ls.getPoints());
                            polygon = new Polygon(new LinearRing[]{lr});
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            polygon = new Polygon(o.getGeom());
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                    int ii = 0;
                    while (ii < polygon.numRings()) {
                        int i = 0;
                        while (i < polygon.getRing(ii).numPoints()) {
                            Point p1 = polygon.getRing(ii).getPoint(i);
                            Node n = new Node();
                            n.setLat(p1.getY());
                            n.setLon(p1.getX());
                            lN.add(n);
                            ++i;
                        }
                        ++ii;
                    }
                    Way w = new Way();
                    w.setNodes(lN.toArray(new Node[lN.size()]));
                    w.setGeom(o.getGeom());
                    listW.add(w);
                }
                ++jj;
            }
            if (listW.size() > 0) {
                t.getValue().setWays(listW.toArray(new Way[listW.size()]));
            }
            ((MapViewer)((PanelContext)this.getViewerContext().getParentContext()).getPanel().getPresentatorForName("value").getViewer()).positionOnWay();
            ((PanelContext)this.getViewerContext().getParentContext()).getPanel().updateUIForPresentatorName("value");
        }
    }
}

