/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.search;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.postgis.LineString;
import org.postgis.LinearRing;
import org.postgis.Polygon;
import ru.blok.cartography.core.ResourceStrings;
import ru.blok.cartography.geozone.GeoZoneViewer;
import ru.blok.cartography.mapviewer.HelpUtils;
import ru.blok.cartography.mapviewer.MapValue;
import ru.blok.cartography.mapviewer.MapViewer;
import ru.blok.cartography.search.ChangeGeoZone;
import ru.blok.cartography.search.ListGeoNodeViewer;
import ru.blok.common.core.CurrentProxyFactory;
import ru.blok.common.core.InitializedVariable;
import ru.blok.common.report.RunReport;
import ru.blok.common.utils.CoordinatesDownTown;
import ru.infor.beanviewer.annotation.Field;
import ru.infor.beanviewer.annotation.ListField;
import ru.infor.beanviewer.annotation.ListView;
import ru.infor.beanviewer.annotation.View;
import ru.infor.beanviewer.dialog.MessageOKButton;
import ru.infor.beanviewer.dialog.WarningMessage;
import ru.infor.beanviewer.swing.viewers.ListActionViewer;
import ru.infor.beanviewer.viewer.ActionButton;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;
import ru.infor.client.soap.proxy.cartography.NodeWSProxy;
import ru.infor.client.soap.proxy.cartography.WayWSProxy;
import ru.infor.ws.objects.cartography.NodeSearchCriteria;
import ru.infor.ws.objects.cartography.Tag;
import ru.infor.ws.objects.cartography.WaySearchCriteria;
import ru.infor.ws.objects.cartography.entities.Node;
import ru.infor.ws.objects.cartography.entities.Way;
import ru.infor.ws.objects.cartography.ext.GeoNode;
import ru.infor.ws.objects.cartography.ext.GeoZone;

@ListView(views={@View(title="\u041f\u043e\u0438\u0441\u043a \u043c\u0435\u0441\u0442\u043e\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043f\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0438\u0441\u0442\u0438\u043a\u0430\u043c", actions={}, layoutKeys={"tabSplitPercentLayoutManager"})})
public class SearchLocationForm {
    WaySearchCriteria scW;
    NodeSearchCriteria scN;
    WayWSProxy wayProxy = (WayWSProxy)CurrentProxyFactory.getProxy(Way.class);
    NodeWSProxy nodeProxy = (NodeWSProxy)CurrentProxyFactory.getProxy(Node.class);
    List<BeanViewerAction<ViewerContext>> listEasyBt = new ArrayList<BeanViewerAction<ViewerContext>>();
    GeoZone geoZone;
    String quickSearch;
    MapValue value;
    List<GeoNode> listPath = new ArrayList<GeoNode>();
    BeanViewerAction<ViewerContext> btSearch = new BeanViewerAction<ViewerContext>(){

        public void actionPerformed(Object arg0) {
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
            if ((SearchLocationForm.this.getGeoZone() == null || SearchLocationForm.this.getGeoZone().getGeom() == null) && SearchLocationForm.this.getQuickSearch() == null) {
                InitializedVariable.getFactory((String)((ViewerContext)this.getContext()).getKeyPage()).runMessageEx((Object)new WarningMessage("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u043d\u043e \u043f\u043e\u043b\u0435 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430."), new BeanViewerAction[]{new MessageOKButton()});
            }
            String ge = null;
            if (SearchLocationForm.this.getGeoZone() != null && SearchLocationForm.this.getGeoZone().getGeom() != null) {
                ge = SearchLocationForm.this.getGeoZone().getGeom();
            }
            if (ge != null && ge.toLowerCase().indexOf("linestring") > -1) {
                try {
                    LineString ls = new LineString(ge);
                    LinearRing lr = new LinearRing(ls.getPoints());
                    Polygon polygon = new Polygon(new LinearRing[]{lr});
                    ge = polygon.toString();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            HelpUtils.putToMapTimes("get Data");
            SearchLocationForm.this.scW = new WaySearchCriteria();
            SearchLocationForm.this.scW.setCount(Integer.valueOf(10));
            SearchLocationForm.this.scW.setGeom(ge);
            SearchLocationForm.this.scW.setQuickSearch(SearchLocationForm.this.getQuickSearch());
            SearchLocationForm.this.listPath.clear();
            WayWSProxy.SearchResultListWay listW = SearchLocationForm.this.wayProxy.getList(InitializedVariable.context, SearchLocationForm.this.scW);
            if (!listW.isEmpty()) {
                int i = 0;
                while (i < listW.getObjList().length) {
                    Way w;
                    GeoNode gn;
                    if (!(SearchLocationForm.this.getGeoZone() != null && ((Way)listW.getObjList()[i]).getId().equals(SearchLocationForm.this.getGeoZone().getId()) || (gn = SearchLocationForm.this.buildGeoNodeFromWay(w = SearchLocationForm.this.wayProxy.getCurrentObject(InitializedVariable.context, ((Way)listW.getObjList()[i]).getId()))) == null)) {
                        SearchLocationForm.this.listPath.add(gn);
                    }
                    ++i;
                }
            }
            SearchLocationForm.this.scN = new NodeSearchCriteria();
            SearchLocationForm.this.scN.setCount(Integer.valueOf(10));
            SearchLocationForm.this.scN.setGeom(ge);
            SearchLocationForm.this.scN.setQuickSearch(SearchLocationForm.this.getQuickSearch());
            NodeWSProxy.SearchResultListNode listN = SearchLocationForm.this.nodeProxy.getList(InitializedVariable.context, SearchLocationForm.this.scN);
            if (!listN.isEmpty()) {
                int i = 0;
                while (i < listN.getObjList().length) {
                    Node n = SearchLocationForm.this.nodeProxy.getCurrentObject(InitializedVariable.context, ((Node)listN.getObjList()[i]).getId());
                    GeoNode gn = SearchLocationForm.this.buildGeoNodeFromNode(n);
                    if (gn != null) {
                        gn.setNode(true);
                        SearchLocationForm.this.listPath.add(gn);
                    }
                    ++i;
                }
            }
            HelpUtils.showDeltaTime("get Data");
            ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
        }

        public String getIcon() {
            return ResourceStrings.btFindData;
        }

        public String getHint() {
            return "\u041f\u043e\u0438\u0441\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432";
        }

        public String getName() {
            return "\u041f\u043e\u0438\u0441\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432";
        }
    };

    public SearchLocationForm() {
        this.addListEasyBt((BeanViewerAction<ViewerContext>)new RunReport());
        Double[] coord = CoordinatesDownTown.getCoordinatesDownTown((Long)InitializedVariable.workplaceId);
        this.value = new MapValue(coord[0], coord[1], coord[2].intValue());
    }

    @ListField(fields={@Field(title="", propertiesUI={"onlyOnePressed=false"}, order=40, propertiesLayout="Split1/h/l/0.25:1", viewer={ListActionViewer.class})})
    public List<BeanViewerAction<ViewerContext>> getListEasyBt() {
        return this.listEasyBt;
    }

    public void addListEasyBt(BeanViewerAction<ViewerContext> newA) {
        this.listEasyBt.add(newA);
    }

    @ListField(fields={@Field(title="\u0413\u0435\u043e\u0437\u043e\u043d\u0430", order=100, propertiesLayout="Split1/h/l/0.25:2///#w 220", emptyItemPresent=true, viewer={GeoZoneViewer.class}, changeAction={ChangeGeoZone.class})})
    public GeoZone getGeoZone() {
        return this.geoZone;
    }

    public void setGeoZone(GeoZone geoZone) {
        this.geoZone = geoZone;
    }

    @ListField(fields={@Field(title=" ", order=200, propertiesLayout="Split1/h/l/0.25:3///#w 320")})
    public String getQuickSearch() {
        return this.quickSearch;
    }

    public void setQuickSearch(String quickSearch) {
        this.quickSearch = quickSearch;
    }

    @ListField(fields={@Field(title="", order=300, propertiesLayout="Split1/h/l/0.25:4///#w 320", viewer={ActionButton.class})})
    public BeanViewerAction<ViewerContext> getbtCalcToHouse() {
        return this.btSearch;
    }

    @ListField(fields={@Field(title="", order=500, viewer={MapViewer.class}, propertiesLayout="Split1/h/r/0.25")})
    public MapValue getValue() {
        return this.value;
    }

    @ListField(fields={@Field(title="", order=400, propertiesLayout="Split1/h/l/0.25:5/h 700, fillx//growx#growx#wrap", viewer={ListGeoNodeViewer.class}, content=GeoNode.class)})
    public List<GeoNode> getListPath() {
        return this.listPath;
    }

    public void setListPath(List<GeoNode> listPath) {
        this.listPath = listPath;
    }

    private GeoNode buildGeoNodeFromNode(Node n) {
        String desc = null;
        if (n.getTags() != null && n.getTags().length > 0) {
            int j = 0;
            while (j < n.getTags().length) {
                if (n.getTags()[j].getKey().equalsIgnoreCase("name")) {
                    desc = n.getTags()[j].getValue();
                    break;
                }
                ++j;
            }
            if (desc == null) {
                desc = n.getTags()[0].getValue();
            }
        }
        if (desc == null) {
            desc = "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f ";
        }
        return new GeoNode(desc, n.getGeom(), n.getLat(), n.getLon());
    }

    private GeoNode buildGeoNodeFromWay(Way w) {
        String desc = null;
        if (w.getTags() != null && w.getTags().length > 0) {
            desc = this.buildName(w.getTags());
        }
        if (desc == null) {
            desc = "\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 ";
        }
        Node n = w.getNodes()[0];
        return new GeoNode(desc, w.getGeom(), n.getLat(), n.getLon());
    }

    private String buildName(Tag[] tags) {
        String desc = null;
        int j = 0;
        while (j < tags.length) {
            if (tags[j].getKey().equalsIgnoreCase("name")) {
                desc = tags[j].getValue();
                break;
            }
            ++j;
        }
        if (desc == null) {
            desc = this.buildAdress(tags);
        }
        if (desc == null) {
            j = 0;
            while (j < tags.length) {
                if (tags[j].getKey().equalsIgnoreCase("objectname")) {
                    desc = tags[j].getValue();
                    break;
                }
                ++j;
            }
        }
        if (desc == null) {
            desc = tags[0].getKey().concat("=").concat(tags[0].getValue());
        }
        return desc;
    }

    private String buildAdress(Tag[] tags) {
        String desc = "";
        String street = null;
        String number = null;
        String city = null;
        int j = 0;
        while (j < tags.length) {
            if (tags[j].getKey().equalsIgnoreCase("addr:street")) {
                street = tags[j].getValue();
            }
            if (tags[j].getKey().equalsIgnoreCase("addr:housenumber")) {
                number = tags[j].getValue();
            }
            if (tags[j].getKey().equalsIgnoreCase("addr:city")) {
                city = tags[j].getValue();
            }
            ++j;
        }
        if (street == null && number == null && city == null) {
            return null;
        }
        if (street != null) {
            desc = street;
        }
        if (number != null) {
            desc = desc.concat(", ").concat(number);
        }
        if (city != null) {
            desc = desc.concat(" /").concat(city).concat("/");
        }
        return desc;
    }
}

