/*
 * Decompiled with CFR 0.152.
 */
package ru.blok.cartography.xml;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import ru.blok.cartography.core.ResourceStrings;
import ru.blok.cartography.xml.SAXModelBuilder;
import ru.blok.cartography.xml.XmlEditor;
import ru.infor.beanviewer.viewer.BeanViewerAction;
import ru.infor.beanviewer.viewer.action.PanelContext;
import ru.infor.beanviewer.viewer.action.ViewerContext;

public class OpenFileXmlBtn
extends BeanViewerAction<ViewerContext> {
    FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return null;
        }
    };

    public void actionPerformed(Object message) {
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateMainObject();
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        jfc.setFileSelectionMode(2);
        jfc.setFileFilter(this.ff);
        int jFile = jfc.showOpenDialog(null);
        if (jFile != 0) {
            return;
        }
        File[] fileList = jfc.getSelectedFiles();
        String filename = fileList[0].getAbsolutePath();
        System.out.println(" -->" + filename);
        if (!filename.endsWith(".xml")) {
            filename = String.valueOf(filename) + ".xml";
        }
        XmlEditor ste = (XmlEditor)((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getObject();
        ste.setFileName(fileList[0].getName());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            SAXModelBuilder mb = new SAXModelBuilder();
            parser.setContentHandler(mb);
            parser.parse(new InputSource(filename));
            ste.setMap(mb.getMap());
            ste.setMapIndex(mb.getMapIndex());
            ste.setCurrentListObject((int)SAXModelBuilder.stepIndex);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUIForPresentatorName("fileName");
        ((PanelContext)((ViewerContext)this.getContext()).getParentContext()).getPanel().updateUI();
    }

    public String getHint() {
        return "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0444\u0430\u0439\u043b Xml";
    }

    public String getIcon() {
        return ResourceStrings.btFileOpen;
    }
}

