/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.ipcam;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.ds.ipcam.IpCamAuth;
import com.github.sarxos.webcam.ds.ipcam.IpCamMode;
import com.github.sarxos.webcam.ds.ipcam.impl.IpCamHttpClient;
import com.github.sarxos.webcam.ds.ipcam.impl.IpCamMJPEGStream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpCamDevice
implements WebcamDevice {
    private static final Logger LOG = LoggerFactory.getLogger(IpCamDevice.class);
    private String name = null;
    private URL url = null;
    private IpCamMode mode = null;
    private IpCamAuth auth = null;
    private IpCamHttpClient client = new IpCamHttpClient();
    private PushImageReader pushReader = null;
    private boolean failOnError = false;
    private volatile boolean open = false;
    private volatile boolean disposed = false;
    private Dimension[] sizes = null;
    private Dimension size = null;

    public IpCamDevice(String name, String url, IpCamMode mode) throws MalformedURLException {
        this(name, new URL(url), mode, null);
    }

    public IpCamDevice(String name, URL url, IpCamMode mode) {
        this(name, url, mode, null);
    }

    public IpCamDevice(String name, String url, IpCamMode mode, IpCamAuth auth) throws MalformedURLException {
        this(name, new URL(url), mode, auth);
    }

    public IpCamDevice(String name, URL url, IpCamMode mode, IpCamAuth auth) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        this.url = url;
        this.mode = mode;
        this.auth = auth;
        if (auth != null) {
            AuthScope scope = new AuthScope(new HttpHost(url.getHost().toString()));
            this.client.getCredentialsProvider().setCredentials(scope, (Credentials)auth);
        }
    }

    protected static final URL toURL(String url) {
        String base = null;
        base = url.startsWith("http://") ? url : String.format("http://%s", url);
        try {
            return new URL(base);
        }
        catch (MalformedURLException e) {
            throw new WebcamException(String.format("Incorrect URL '%s'", url), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Dimension[] getResolutions() {
        if (this.sizes != null) {
            return this.sizes;
        }
        if (!this.open) {
            this.open();
        }
        int attempts = 0;
        do {
            BufferedImage img;
            if ((img = this.getImage()) == null) continue;
            this.sizes = new Dimension[]{new Dimension(img.getWidth(), img.getHeight())};
            break;
        } while (attempts++ < 5);
        this.close();
        if (this.sizes == null) {
            throw new WebcamException("Cannot get initial image from IP camera device " + this.getName());
        }
        return this.sizes;
    }

    protected void setSizes(Dimension[] sizes) {
        this.sizes = sizes;
    }

    public Dimension getResolution() {
        if (this.size == null) {
            this.size = this.getResolutions()[0];
        }
        return this.size;
    }

    public void setResolution(Dimension size) {
        this.size = size;
    }

    public synchronized BufferedImage getImage() {
        if (!this.open) {
            throw new WebcamException("IpCam device not open");
        }
        switch (this.mode) {
            case PULL: {
                return this.getImagePullMode();
            }
            case PUSH: {
                return this.getImagePushMode();
            }
        }
        throw new WebcamException(String.format("Unsupported mode %s", new Object[]{this.mode}));
    }

    private BufferedImage getImagePushMode() {
        if (this.pushReader == null) {
            URI uri = null;
            try {
                uri = this.getURL().toURI();
            }
            catch (URISyntaxException e) {
                throw new WebcamException(String.format("Incorrect URI syntax '%s'", uri), (Throwable)e);
            }
            this.pushReader = new PushImageReader(uri);
            Thread thread = new Thread((Runnable)this.pushReader, String.format("%s-reader", this.getName()));
            thread.setDaemon(true);
            thread.start();
        }
        return this.pushReader.getImage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage getImagePullMode() {
        IpCamDevice ipCamDevice = this;
        synchronized (ipCamDevice) {
            HttpGet get = null;
            URI uri = null;
            try {
                uri = this.getURL().toURI();
            }
            catch (URISyntaxException e) {
                throw new WebcamException(String.format("Incorrect URI syntax '%s'", uri), (Throwable)e);
            }
            BasicHttpContext context = new BasicHttpContext();
            IpCamAuth auth = this.getAuth();
            if (auth != null) {
                BasicAuthCache cache = new BasicAuthCache();
                cache.put(new HttpHost(uri.getHost()), (AuthScheme)new BasicScheme());
                context.setAttribute("http.auth.auth-cache", (Object)cache);
            }
            try {
                get = new HttpGet(uri);
                HttpResponse respone = this.client.execute((HttpUriRequest)get, (HttpContext)context);
                HttpEntity entity = respone.getEntity();
                Header ct = entity.getContentType();
                if (ct == null) {
                    throw new WebcamException("Content Type header is missing");
                }
                if (ct.getValue().startsWith("multipart/")) {
                    throw new WebcamException("Cannot read MJPEG stream in PULL mode, change mode to PUSH");
                }
                InputStream is = entity.getContent();
                if (is == null) {
                    BufferedImage bufferedImage = null;
                    return bufferedImage;
                }
                BufferedImage bufferedImage = ImageIO.read(is);
                return bufferedImage;
            }
            catch (IOException e) {
                if (!e.getMessage().equals("closed")) throw new WebcamException("Cannot download image", (Throwable)e);
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            catch (Exception e) {
                throw new WebcamException("Cannot download image", (Throwable)e);
            }
            finally {
                if (get != null) {
                    get.releaseConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnline() {
        LOG.debug("Checking online status for {} at {}", (Object)this.getName(), (Object)this.getURL());
        URI uri = null;
        try {
            uri = this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new WebcamException(String.format("Incorrect URI syntax '%s'", uri), (Throwable)e);
        }
        HttpHead head = new HttpHead(uri);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)head);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (head != null) {
                head.releaseConnection();
            }
        }
        return response.getStatusLine().getStatusCode() != 404;
    }

    public void open() {
        if (this.disposed) {
            LOG.warn("Device cannopt be open because it's already disposed");
            return;
        }
        this.open = true;
    }

    public void close() {
        if (!this.open) {
            return;
        }
        if (this.pushReader != null) {
            this.pushReader.stop();
            this.pushReader = null;
        }
        this.open = false;
    }

    public URL getURL() {
        return this.url;
    }

    public IpCamMode getMode() {
        return this.mode;
    }

    public IpCamAuth getAuth() {
        return this.auth;
    }

    public void setAuth(IpCamAuth auth) {
        if (auth != null) {
            URL url = this.getURL();
            AuthScope scope = new AuthScope(url.getHost(), url.getPort());
            this.client.getCredentialsProvider().setCredentials(scope, (Credentials)auth);
        }
    }

    public void resetAuth() {
        this.client.getCredentialsProvider().clear();
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    private final class PushImageReader
    implements Runnable {
        private final Object lock = new Object();
        private IpCamMJPEGStream stream = null;
        private BufferedImage image = null;
        private boolean running = true;
        private WebcamException exception = null;
        private HttpGet get = null;
        private URI uri = null;

        public PushImageReader(URI uri) {
            this.uri = uri;
            this.stream = new IpCamMJPEGStream(this.requestStream(uri));
        }

        private InputStream requestStream(URI uri) {
            BasicHttpContext context = new BasicHttpContext();
            IpCamAuth auth = IpCamDevice.this.getAuth();
            if (auth != null) {
                BasicAuthCache cache = new BasicAuthCache();
                cache.put(new HttpHost(uri.getHost()), (AuthScheme)new BasicScheme());
                context.setAttribute("http.auth.auth-cache", (Object)cache);
            }
            try {
                this.get = new HttpGet(uri);
                HttpResponse respone = IpCamDevice.this.client.execute((HttpUriRequest)this.get, (HttpContext)context);
                HttpEntity entity = respone.getEntity();
                Header ct = entity.getContentType();
                if (ct == null) {
                    throw new WebcamException("Content Type header is missing");
                }
                if (ct.getValue().startsWith("image/")) {
                    throw new WebcamException("Cannot read images in PUSH mode, change mode to PULL");
                }
                return entity.getContent();
            }
            catch (Exception e) {
                throw new WebcamException("Cannot download image", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running && !this.stream.isClosed()) {
                try {
                    LOG.trace("Reading MJPEG frame");
                    BufferedImage image = this.stream.readFrame();
                    if (image == null) continue;
                    this.image = image;
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.notifyAll();
                    }
                }
                catch (IOException e) {
                    if (this.stream.isClosed()) {
                        LOG.debug("Stream already closed, returning");
                        return;
                    }
                    if (e instanceof EOFException) {
                        LOG.debug("EOF detected, recreating MJPEG stream");
                        this.get.releaseConnection();
                        try {
                            this.stream.close();
                        }
                        catch (IOException ioe) {
                            throw new WebcamException((Throwable)ioe);
                        }
                        this.stream = new IpCamMJPEGStream(this.requestStream(this.uri));
                        continue;
                    }
                    LOG.error("Cannot read MJPEG frame", (Throwable)e);
                    if (!IpCamDevice.this.failOnError) continue;
                    this.exception = new WebcamException("Cannot read MJPEG frame", (Throwable)e);
                    throw this.exception;
                }
            }
            try {
                this.stream.close();
            }
            catch (IOException e) {
                LOG.debug("Some nasty exception when closing MJPEG stream", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BufferedImage getImage() {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.image == null) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new WebcamException("Reader thread interrupted", (Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem waiting on lock", e);
                }
            }
            return this.image;
        }

        public void stop() {
            this.running = false;
        }
    }
}

