package ru.infor.synchro;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;

import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

import ru.infor.synchro.internal.Exporter;
import ru.infor.synchro.internal.Importer;
import ru.infor.synchro.internal.SynchronizationParams;

public class SynchronizationProvider {

	public static SynchronizationProvider provider = null;

	Logger logger = Logger.getLogger(SynchronizationProvider.class);

	Object invocationContext;

	public static SynchronizationProvider getProvider(Object invocationContext) {
		if (provider == null)
			provider = new SynchronizationProvider();

		provider.invocationContext = invocationContext;
		return provider;
	}

	private SynchronizationProvider() {
		super();
	}

	public File exportData(SynchronizationParams params,
			SessionBeanSupplier sessionsupplier, SynchroHistory synchstory) {
		if (params.isError())
			throw new SynchronizationException(
					"Provider has not been initialized.");
		if (sessionsupplier == null)
			throw new SynchronizationException(
					"SessionBeanSupplier has not been initialized");

		InputSource is = new InputSource(new ByteArrayInputStream(new byte[0]));

		File file = null;
		try {
			file = File.createTempFile("export_"
					+ String.valueOf(System.currentTimeMillis()), ".xml");
		} catch (IOException e) {
			logger.error("exception = " + e.getMessage());
			throw new SynchronizationException("Unable to create output file");
		}

		try {
			SAXSource source = new SAXSource(new Exporter(params,
					sessionsupplier, synchstory, invocationContext), is);
			StreamResult result = new StreamResult(file);

			Transformer transformer = SAXTransformerFactory.newInstance()
					.newTransformer();

			transformer.transform(source, result);
		} catch (Exception e) {
			logger.error("exception = " + e.getMessage(), e);
			// e.printStackTrace();
		}

		return file;
	}

	public boolean importData(SynchronizationParams params, File inputFile,
			SessionBeanSupplier sessionsupplier) {
		if (params.isError())
			throw new SynchronizationException(
					"Provider has not been initialized.");
		if (sessionsupplier == null)
			throw new SynchronizationException(
					"SessionBeanSupplier has not been initialized");

		try {
			SAXParserFactory.newInstance().newSAXParser().parse(inputFile,
					new Importer(params, sessionsupplier, invocationContext));
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			// e.printStackTrace();
			return false;
		}

		return true;
	}

}
