package ru.infor.synchro.internal;

import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

import ru.infor.synchro.SessionBeanSupplier;
import ru.infor.synchro.SynchroHistory;
import ru.infor.synchro.SynchronizableBO;

public class Exporter implements XMLReader {

	Logger logger = Logger.getLogger(Exporter.class);

	ContentHandler handler;

	SynchronizationParams params;

	SessionBeanSupplier sessionsupplier;

	SynchroHistory synchstory;

	Object invocationContext;

	public Exporter(SynchronizationParams params,
			SessionBeanSupplier sessionsupplier, SynchroHistory story,
			Object invocationContext) {
		super();

		this.params = params;
		this.sessionsupplier = sessionsupplier;
		this.synchstory = story;
		this.invocationContext = invocationContext;
	}

	public ContentHandler getContentHandler() {
		return handler;
	}

	public void setContentHandler(ContentHandler handler) {
		this.handler = handler;

	}

	public void parse(InputSource input) throws IOException, SAXException {
		handler.startDocument();
		handler.startElement(SynchXMLTags.NAME_SPACE, SynchXMLTags.DOCUMENT,
				SynchXMLTags.DOCUMENT, new AttributesImpl());

		for (SynchBeanInfo info : params.getFlow()) {
			Object bean = sessionsupplier.getSessionBean(info.getJndiName());
			if (!SynchronizableBO.class.isAssignableFrom(bean.getClass())) {
				logger.error("bean: " + info.getJndiName()
						+ "does not implement: "
						+ SynchronizableBO.class.getName());

				continue;
			}
			SynchronizableBO sBO = (SynchronizableBO) bean;
			List<?> entities = sBO.getSynchronizableObjects(invocationContext,
					synchstory.getLastSynchronizationDate());

			for (Object obj : entities) {
				try {
					ObjectExporter.setTransientlist(info.getTransientlist());
					ObjectExporter.export(obj, new Object2XMLResult(handler));
				} catch (Exception e) {
					logger.error(e.getMessage(), e);
					e.printStackTrace();
				}
			}
		}

		handler.endElement(SynchXMLTags.NAME_SPACE, SynchXMLTags.DOCUMENT,
				SynchXMLTags.DOCUMENT);
		handler.endDocument();
	}

	public void parse(String systemId) throws IOException, SAXException {
		parse((InputSource) null);
	}

	public DTDHandler getDTDHandler() {
		return null;
	}

	public EntityResolver getEntityResolver() {
		return null;
	}

	public ErrorHandler getErrorHandler() {
		return null;
	}

	public boolean getFeature(String name) throws SAXNotRecognizedException,
			SAXNotSupportedException {
		return false;
	}

	public Object getProperty(String name) throws SAXNotRecognizedException,
			SAXNotSupportedException {
		return null;
	}

	public void setDTDHandler(DTDHandler handler) {

	}

	public void setEntityResolver(EntityResolver resolver) {

	}

	public void setErrorHandler(ErrorHandler handler) {

	}

	public void setFeature(String name, boolean value)
			throws SAXNotRecognizedException, SAXNotSupportedException {

	}

	public void setProperty(String name, Object value)
			throws SAXNotRecognizedException, SAXNotSupportedException {

	}

}
