package ru.infor.synchro.internal;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;

import ru.infor.synchro.SynchronizationException;

public class FieldUtils {

	static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");

	public static String getFieldName(String getterName) {
		String fldName = getterName.substring(3);
		return fldName.substring(0, 1).toLowerCase() + fldName.substring(1);
	}

	public static String getGetterName(String fieldName) {
		return "get" + fieldName.substring(0, 1).toUpperCase()
				+ fieldName.substring(1);
	}

	public static String getSetterName(String fieldName) {
		return "set" + fieldName.substring(0, 1).toUpperCase()
				+ fieldName.substring(1);
	}

	public static String fieldValue2String(Object value) {
		if (value instanceof String)
			return (String) value;

		if (value instanceof Date) {
			Date dateValue = (Date) value;
			return df.format(dateValue);
		}

		return String.valueOf(value);
	}

	public static Object string2FieldValue(Class fldType, String value)
			throws Exception {
		Logger.getLogger(FieldUtils.class).debug("fldType: " + fldType);

		if (String.class.isAssignableFrom(fldType))
			return value;

		if (fldType.isPrimitive())
			return getPrimitiveValue(fldType, value);

		if (Date.class.isAssignableFrom(fldType))
			return getDateTimeValue(fldType, value);

		return getValue(fldType, value);
	}

	private static Object getDateTimeValue(Class fldType, String value)
			throws ParseException {
		Date res = df.parse(value);
		if (java.sql.Date.class.isAssignableFrom(fldType))
			return new java.sql.Date(res.getTime());

		if (Time.class.isAssignableFrom(fldType))
			return new Time(res.getTime());

		if (Timestamp.class.isAssignableFrom(fldType))
			return new Timestamp(res.getTime());

		return res;
	}

	private static Object getValue(Class fldType, String value) {
		if (Double.class.isAssignableFrom(fldType))
			return Double.valueOf(value);

		if (Float.class.isAssignableFrom(fldType))
			return Float.valueOf(value);

		if (Integer.class.isAssignableFrom(fldType))
			return Integer.valueOf(value);

		if (Long.class.isAssignableFrom(fldType))
			return Long.valueOf(value);

		if (Byte.class.isAssignableFrom(fldType))
			return Byte.valueOf(value);

		if (Short.class.isAssignableFrom(fldType))
			return Short.valueOf(value);

		throw new SynchronizationException("type: " + fldType
				+ " is not supported");
	}

	private static Object getPrimitiveValue(Class fldType, String value) {
		if (double.class.isAssignableFrom(fldType))
			return Double.valueOf(value).doubleValue();

		if (float.class.isAssignableFrom(fldType))
			return Double.valueOf(value).floatValue();

		if (int.class.isAssignableFrom(fldType))
			return Integer.valueOf(value).intValue();

		if (long.class.isAssignableFrom(fldType))
			return Long.valueOf(value).longValue();

		if (byte.class.isAssignableFrom(fldType))
			return Integer.valueOf(value).byteValue();

		if (short.class.isAssignableFrom(fldType))
			return Integer.valueOf(value).shortValue();

		throw new SynchronizationException("type: " + fldType
				+ " is not supported");
	}
}
