package ru.infor.synchro.internal;

import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import ru.infor.synchro.SessionBeanSupplier;
import ru.infor.synchro.Synchronizable;
import ru.infor.synchro.SynchronizableBO;
import ru.infor.synchro.SynchronizationException;

public class Importer extends DefaultHandler {

	Logger logger = Logger.getLogger(Importer.class);

	SynchronizationParams params;

	SessionBeanSupplier sessionsupplier;

	Object invocationContext;

	ObjectImporter objectImporter = null;

	boolean isFieldValue = false;

	StringBuffer fldStrValue;

	Object fldValue = null;

	public Importer(SynchronizationParams params,
			SessionBeanSupplier sessionsupplier, Object invocationContext) {
		super();

		this.params = params;
		this.sessionsupplier = sessionsupplier;
		this.invocationContext = invocationContext;
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if (qName.equals(SynchXMLTags.OBJECT)) {
			String className = attributes
					.getValue(SynchXMLTags.OBJECT_CLASS_ATTR);
			if (objectImporter != null)
				logger.warn("Internal error: objectImporter is not NULL");

			objectImporter = new ObjectImporter(className);
			if (objectImporter.getObj() == null)
				throw new SynchronizationException(
						"Object importer hasnot been initializated");
		} else if (qName.equals(SynchXMLTags.FIELD)) {
			objectImporter.setFldName(attributes
					.getValue(SynchXMLTags.FIELD_NAME_ATTR));
			objectImporter.setFldNull(attributes
					.getValue(SynchXMLTags.FIELD_IS_NULL_ATTR));
		} else if (qName.equals(SynchXMLTags.FIELD_VALUE)) {
			isFieldValue = true;
			fldStrValue = new StringBuffer();
		} else if (qName.equals(SynchXMLTags.OBJECT_REF)) {
			String ref = attributes.getValue(SynchXMLTags.OBJECT_REF_ATTR);
			fldValue = lookup(attributes
					.getValue(SynchXMLTags.OBJECT_REF_CLASS_ATTR), ref);
			logger.debug("object-ref: " + ref + "; object: " + fldValue);
		}
	}

	private Object lookup(String entityClass, String ref) {
		SynchronizableBO sBO = null;
		try {
			sBO = getSynchronizableBO(Class.forName(entityClass));
		} catch (ClassNotFoundException e) {
			logger.error(e.getMessage(), e);
			;
		}
		if (sBO == null)
			return null;

		return sBO.lookupSynchObject(invocationContext, ref);

	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if (!isFieldValue)
			return;

		fldStrValue.append(ch, start, length);
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if (qName.equals(SynchXMLTags.OBJECT))
			try {
				saveObject();
				objectImporter = null;
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}
		else if (qName.equals(SynchXMLTags.FIELD))
			objectImporter.setCurrentFieldValue(fldValue);
		else if (qName.equals(SynchXMLTags.FIELD_VALUE)) {
			try {
				Class clazz = objectImporter.getCurrentFieldClass();
				String strValue = fldStrValue.toString();
				try {
					fldValue = FieldUtils.string2FieldValue(clazz, strValue);
				} catch (Exception e) {
					logger.error("Unable to conver value: " + strValue
							+ " to class: " + clazz.getName());
					fldValue = null;
				}
			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			}

			isFieldValue = false;
			fldStrValue = null;
		}
	}

	private SynchronizableBO getSynchronizableBO(Class<?> clazz) {
		SynchBeanInfo info = params.beans.get(clazz);
		if (info == null) {
			logger.error("Unable to locate configuration "
					+ "for entity class: " + clazz.getName());
			return null;
		}

		Object bean = sessionsupplier.getSessionBean(info.getJndiName());
		if (bean == null) {
			logger.error("Unable to locate EJB: " + info.getJndiName());
			return null;
		}

		if (!SynchronizableBO.class.isAssignableFrom(bean.getClass())) {
			logger.error("Bean: " + info.getJndiName()
					+ " does not implement interface: "
					+ SynchronizableBO.class.getName());
			return null;
		}

		return (SynchronizableBO) bean;
	}

	private void saveObject() throws Exception {
		if (objectImporter == null)
			throw new SynchronizationException(
					"Object importer has not been initializated");

		SynchronizableBO sBO = getSynchronizableBO(objectImporter.getObj()
				.getClass());
		if (sBO == null)
			return;

		Object dbObj = sBO.lookupSynchObject(invocationContext,
				((Synchronizable) objectImporter.getObj()).getUniqueKey());
		if (dbObj != null) {
			// ObjectExporter.setTransientlist(null);
			ObjectExporter.export(objectImporter.getObj(),
					new Object2ObjectResult(dbObj));
			logger.debug("Object was found");
		} else {
			dbObj = objectImporter.getObj();
			logger.debug("Object was not found");
		}

		sBO.saveSynchObject(invocationContext, dbObj);
	}
}
