package ru.infor.synchro.internal;

import java.lang.reflect.Method;

class Object2ObjectResult implements ExporterResult {

	Object dest;

	public Object2ObjectResult(Object obj) {
		super();

		dest = obj;
	}

	public void endObject(Object obj) throws Exception {
	}

	public void exportField(String fldName, Object value) throws Exception {
		String setterName = FieldUtils.getSetterName(fldName);
		
		Method getter = dest.getClass().getMethod(FieldUtils.getGetterName(fldName), new Class[0]); 
		Method mtd = dest.getClass().getMethod(setterName, new Class<?> [] {getter.getReturnType()});
		
		mtd.invoke(dest, new Object[] {value});
	}

	public void startObject(Object obj) throws Exception {
	}

}
