package ru.infor.synchro.internal;

import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import ru.infor.synchro.Synchronizable;

class Object2XMLResult implements ExporterResult {

	ContentHandler handler;

	public Object2XMLResult(ContentHandler handler) {
		super();

		this.handler = handler;
	}

	public void startObject(Object obj) throws Exception {
		AttributesImpl atts = new AttributesImpl();
		atts.addAttribute(SynchXMLTags.NAME_SPACE,
				SynchXMLTags.OBJECT_CLASS_ATTR, SynchXMLTags.OBJECT_CLASS_ATTR,
				"string", obj.getClass().getName());

		handler.startElement(SynchXMLTags.NAME_SPACE, SynchXMLTags.OBJECT,
				SynchXMLTags.OBJECT, atts);

	}

	public void exportField(String fldName, Object value) throws Exception {
		AttributesImpl atts = new AttributesImpl();

		atts.addAttribute(SynchXMLTags.NAME_SPACE,
				SynchXMLTags.FIELD_NAME_ATTR, SynchXMLTags.FIELD_NAME_ATTR,
				"string", fldName);
		atts.addAttribute(SynchXMLTags.NAME_SPACE,
				SynchXMLTags.FIELD_IS_NULL_ATTR,
				SynchXMLTags.FIELD_IS_NULL_ATTR, "string",
				(value == null) ? "1" : "0");
		handler.startElement(SynchXMLTags.NAME_SPACE, SynchXMLTags.FIELD,
				SynchXMLTags.FIELD, atts);

		if (value != null)
			exportFieldValue(handler, value);

		handler.endElement(SynchXMLTags.NAME_SPACE, SynchXMLTags.FIELD,
				SynchXMLTags.FIELD);
	}

	private static void exportFieldValue(ContentHandler handler, Object value)
			throws SAXException {
		AttributesImpl atts = new AttributesImpl();
		if (Synchronizable.class.isAssignableFrom(value.getClass())) {
			atts.addAttribute(SynchXMLTags.NAME_SPACE,
					SynchXMLTags.OBJECT_REF_CLASS_ATTR,
					SynchXMLTags.OBJECT_REF_CLASS_ATTR, "string", value
							.getClass().getName());
			atts.addAttribute(SynchXMLTags.NAME_SPACE,
					SynchXMLTags.OBJECT_REF_ATTR, SynchXMLTags.OBJECT_REF_ATTR,
					"string", ((Synchronizable) value).getUniqueKey());
			handler.startElement(SynchXMLTags.NAME_SPACE,
					SynchXMLTags.OBJECT_REF, SynchXMLTags.OBJECT_REF, atts);
			handler.endElement(SynchXMLTags.NAME_SPACE,
					SynchXMLTags.OBJECT_REF, SynchXMLTags.OBJECT_REF);
		} else {
			handler.startElement(SynchXMLTags.NAME_SPACE,
					SynchXMLTags.FIELD_VALUE, SynchXMLTags.FIELD_VALUE, atts);
			String strValue = FieldUtils.fieldValue2String(value);
			handler.characters(strValue.toCharArray(), 0, strValue.length());
			handler.endElement(SynchXMLTags.NAME_SPACE,
					SynchXMLTags.FIELD_VALUE, SynchXMLTags.FIELD_VALUE);
		}
	}

	public void endObject(Object obj) throws Exception {
		handler.endElement(SynchXMLTags.NAME_SPACE, SynchXMLTags.OBJECT,
				SynchXMLTags.OBJECT);
	}

}
