package ru.infor.synchro.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;

class ObjectExporter {

	static Logger logger = Logger.getLogger(ObjectExporter.class);
	private static List<String> transientlist=new ArrayList<String>();
	public static void setTransientlist(List<String> list){
		transientlist=list;
	}

	public static void export(Object source, ExporterResult result)
			throws Exception {
		logger.debug("trying to export object: " + source);

		result.startObject(source);

		Method[] methods = source.getClass().getMethods();
		for (int i = 0; i < methods.length; i++) {
			Method mtd = methods[i];

			

			boolean validExportMethod = (mtd.getName().startsWith("get")
					&& !mtd.getName().equals("getClass")
					&& mtd.getReturnType() != null && mtd.getParameterTypes().length == 0);
			if (!validExportMethod)
				continue;

			String fldName = FieldUtils.getFieldName(mtd.getName());
			boolean trans=false;
			if ((transientlist!=null)&&( transientlist.size()!=0)){
				for(String field:transientlist){
					if (field.equals(fldName)){
						trans=true;
						continue;
					}
				}
			if (trans) continue;	
			}
			Object value = null;

			try {
				value = mtd.invoke(source, new Object[0]);
				logger.debug("    " + fldName + " = " + value);
			} catch (Exception e) {
				logger.warn("error on get value of " + mtd.getName(), e);
			}

			result.exportField(fldName, value);
		}

		result.endObject(source);
	}

}
