package ru.infor.synchro.internal;

import java.lang.reflect.Method;

import org.apache.log4j.Logger;

class ObjectImporter {

	private Logger logger = Logger.getLogger(ObjectImporter.class);

	private Object obj;

	// contains a name of current fiels that has been read
	private String fldName;

	private boolean fldNull;

	public ObjectImporter(String className) {
		super();

		try {
			obj = Class.forName(className).newInstance();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			obj = null;
		}
	}

	public void setCurrentFieldValue(Object fldValue) {
		if (fldNull)
			fldValue = null;

		logger.debug("fldName: " + fldName + "; fldValue: " + fldValue);

		try {
			Method mtd = obj.getClass().getMethod(
					FieldUtils.getSetterName(fldName),
					new Class[] { getCurrentFieldClass() });
			mtd.invoke(obj, new Object[] { fldValue });
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}

		fldName = null;
	}

	public Class<?> getCurrentFieldClass() throws SecurityException,
			NoSuchMethodException {
		return obj.getClass().getMethod(FieldUtils.getGetterName(fldName),
				new Class[0]).getReturnType();
	}

	public Object getObj() {
		return obj;
	}

	public String getFldName() {
		return fldName;
	}

	public void setFldName(String fldName) {
		this.fldName = fldName;
	}

	public void setFldNull(String value) {
		this.fldNull = value.equals("1");
	}

	public boolean isFldNull() {
		return fldNull;
	}

}
