package ru.infor.synchro.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import org.apache.log4j.Logger;

import ru.infor.synchro.SynchConfig;
import ru.infor.synchro.SynchConfigItem;
import ru.infor.synchro.Synchronizable;
import ru.infor.synchro.SynchronizationException;

public class SynchronizationParams {

	Logger logger = Logger.getLogger(SynchronizationParams.class);

	boolean error = true;

	HashMap<Class<?>, SynchBeanInfo> beans;

	List<SynchBeanInfo> flow;

	public SynchronizationParams(SynchConfig config) {
		super();

		try {
			loadProcessingFlow(config);
		} catch (Exception e) {
			logger.error("exception = " + e.getMessage(), e);
			throw new SynchronizationException(e);
		}

	}

	// private void loadProcessingFlow(InputStream in) throws SAXException,
	//	 
	// IOException, ParserConfigurationException, ClassNotFoundException {
	// flow = new ArrayList<SynchBeanInfo>();
	// beans = new HashMap<Class<?>, SynchBeanInfo>();
	//		
	// if (in == null)
	// {logger.error("Can nao load params");
	// }
	//
	// Document document = DocumentBuilderFactory.newInstance()
	// .newDocumentBuilder().parse(in);
	// NodeList nodeList = document.getElementsByTagName("bean");
	//
	// for (int i = 0; i < nodeList.getLength(); i++) {
	// Node n = nodeList.item(i);
	// NamedNodeMap attrsMap = n.getAttributes();
	//
	// SynchBeanInfo bi = new SynchBeanInfo();
	// bi.setJndiName(attrsMap.getNamedItem("jndi-name").getNodeValue());
	// if (bi.getJndiName() == null || bi.getJndiName().length() == 0) {
	// logger.error("incorrect bean description. "
	// + "jndi-name attribute was not specified");
	// logger.error("bean was excluded from synchronization process");
	//
	// continue;
	// }
	//
	// String orderIndex = attrsMap.getNamedItem("order-index")
	// .getNodeValue();
	//			
	// try {
	// bi.setOrderIndex(Integer.valueOf(orderIndex));
	// } catch (Exception e) {
	// logger.warn("incorrect value of attribute order-index: "
	// + orderIndex);
	// bi.setOrderIndex(0);
	// }
	//
	// String entityClsName = attrsMap.getNamedItem("entity-class")
	// .getNodeValue();
	// if (entityClsName == null || entityClsName.length() == 0) {
	// logger.error("incorrect bean description. "
	// + "entity-class attribute was not specified");
	// logger.error("bean: " + bi.getJndiName()
	// + " was excluded from synchronization process");
	//
	// continue;
	// }
	//
	// Class<?> cls = Class.forName(entityClsName);
	// if (!Synchronizable.class.isAssignableFrom(cls)) {
	// logger.error("class: " + cls
	// + " does not implement interface: "
	// + Synchronizable.class.getName());
	// logger.error("bean: " + bi.getJndiName()
	// + " was excluded from synchronization process");
	//
	// continue;
	// }
	// //boolean f=false;
	// NodeList list=n.getChildNodes();
	// List<String>transientlist=new ArrayList<String>();
	// if (list.getLength()>0)
	// for (int j = 0; j < list.getLength(); j++) {
	// Node item=list.item(j);
	// NamedNodeMap transmap=item.getAttributes();
	// if (list.item(j).getNodeName().equals("transient")){
	// String fldname = transmap.getNamedItem("field").getNodeValue();
	// transientlist.add(fldname);
	// }
	// }
	//					
	// bi.setEntityClass(cls);
	// bi.setTransientlist(transientlist);
	// flow.add(bi);
	// beans.put(cls, bi);
	// }
	//
	// Collections.sort(flow);
	// document = null;
	// error = false;
	// }

	private void loadProcessingFlow(SynchConfig config)
			throws ClassNotFoundException {
		flow = new ArrayList<SynchBeanInfo>();
		beans = new HashMap<Class<?>, SynchBeanInfo>();
		if ((config == null) || (config.getSynchInfo() == null)
				|| (config.getSynchInfo() == null)) {
			logger.error("Can not load parameters");
			error = true;
			return;
		}

		for (SynchConfigItem bean : config.getSynchInfo()) {
			SynchBeanInfo info = new SynchBeanInfo();
			if ((bean.getSessionname() == null)
					|| (bean.getSessionname().length() == 0)) {
				logger.error("incorrect bean description. "
						+ "sessionName attribute was not specified");
				logger.error("bean was excluded from synchronization process");

				continue;
			}
			info.setJndiName(bean.getSessionname());
			if ((bean.getEntityname() == null)
					|| (bean.getEntityname().length() == 0)) {
				logger.error("incorrect bean description. "
						+ "entity-class attribute was not specified");
				logger.error("bean: " + info.getJndiName()
						+ " was excluded from synchronization process");

				continue;
			}

			Class<?> cls = Class.forName(bean.getEntityname());
			if (!Synchronizable.class.isAssignableFrom(cls)) {
				logger.error("class: " + cls
						+ " does not implement interface: "
						+ Synchronizable.class.getName());
				logger.error("bean: " + info.getJndiName()
						+ " was excluded from synchronization process");

				continue;
			}
			info.setEntityClass(cls);
			try {
				info.setOrderIndex(Integer.valueOf(bean.getOrderindex()));
			} catch (Exception e) {
				logger.warn("incorrect value of attribute order-index: "
						+ bean.getOrderindex());
				info.setOrderIndex(0);
			}
			List<String> tl = new ArrayList<String>();
			if (bean.getTransientfields() != null)
				tl.addAll(Arrays.asList(bean.getTransientfields()));
			info.setTransientlist(tl);
			
			flow.add(info);
			beans.put(cls, info);
		}
		Collections.sort(flow);

		error = false;
	}

	public List<SynchBeanInfo> getFlow() {
		return flow;
	}

	public boolean isError() {
		return error;
	}

}