package ru.infor.websocket.client;

import java.lang.reflect.Method;

import org.apache.log4j.Logger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

class ClientHandler {

	private static final Logger logger = Logger.getLogger(ClientHandler.class);

	Gson gson = new GsonBuilder().create();
	boolean init = false;

	Object instance;
	Method method;
	Class<?> paramClass = Void.class;

	protected ClientHandler(Object sInstance, String methodName) {
		super();
		this.instance = sInstance;
		Method[] methods = sInstance.getClass().getMethods();
		for (Method m : methods) {
			if (m.getName().equals(methodName)) {
				this.method = m;
				if (m.getParameterTypes() != null && m.getParameterTypes().length > 0)
					this.paramClass = m.getParameterTypes()[0];
			}
		}
	}

	public synchronized boolean isInit() {
		return init;
	}

	public synchronized void setInit(boolean init) {
		this.init = init;
	}

	protected Object invoke(final String className, Object mtdParam) {
		try {
			return method.invoke(instance, new Object[] { mtdParam });
		} catch (Throwable t) {
			logger.error(t.getMessage(), t);
		}

		return null;
	}

}
