package ru.infor.websocket.client;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.management.RuntimeErrorException;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;

import org.apache.log4j.Logger;

import ru.infor.common.SysProperties;
import ru.infor.websocket.transport.SubscribingOptions;
import ru.infor.websocket.transport.UnsubscribingOptions;

public class SocketClientFactory {

	static Map<URI, ClientEndpoint> endpoints = new LinkedHashMap<URI, ClientEndpoint>();

	@Deprecated
	public static <T, E> String subscribe(T subscriberInstance, SubscribingOptions<E> options) throws Exception {
		return subscribe(subscriberInstance, options, "vms-ws");
	}

	public static <T, E> String subscribe(T subscriberInstance, SubscribingOptions<E> options, String appName)
			throws Exception {
		URI endpointURI = getURIbyAppName(appName);
		return subscribe(subscriberInstance, options, endpointURI);
	}

	private static URI getURIbyAppName(String appName) {
		String soapURL = SysProperties.getProperty(appName + ".soap.services.url", null);
		if (soapURL == null) {
			Logger.getLogger(SocketClientFactory.class).error("property is not set: " + appName + ".soap.services.url");
			soapURL = "http://infor.trans-monitor.ru:9393/vms-ws/services/";
		}
		while (true) {
			boolean flag = false;
			for (String term : new String[] { "/", "services" })
				if (soapURL.endsWith(term)) {
					flag = true;
					soapURL = soapURL.substring(0, soapURL.length() - term.length());
					break;
				}
			if (!flag)
				break;
		}

		if (soapURL.startsWith("http"))
			soapURL = soapURL.replace("http", "ws");

		URI endpointURI = URI.create(soapURL + "/socket");
		return endpointURI;
	}

	public static <T, E> String subscribe(T subscriberInstance, SubscribingOptions<E> options, URI endpointURI)
			throws Exception {
		ClientEndpoint endpoint = getEndpoint(endpointURI);
		return endpoint.subscribe(options, new ClientHandler(subscriberInstance, options.getMethodName()));
	}

	@Deprecated
	public static void unsubscribe(UnsubscribingOptions options) throws Exception {
		unsubscribe(options, "vms-ws");
	}

	public static void unsubscribe(UnsubscribingOptions options, String appName) throws Exception {
		unsubscribe(options, getURIbyAppName(appName));
	}

	public static void unsubscribe(UnsubscribingOptions options, URI endpointURI) throws Exception {
		if (options == null)
			throw new NullPointerException("UnsubscribingOptions are mandatory");
		if (options.getSid() == null)
			throw new NullPointerException("UnsubscribingOptions.sid field is mandatory");

		ClientEndpoint endpoint = getEndpoint(endpointURI);
		endpoint.unsubscribe(options);
	}

	private synchronized static ClientEndpoint getEndpoint(URI endpointURI) throws Exception {
		if (endpointURI == null)
			throw new RuntimeException("endpointURI is mandatory");

		String str = endpointURI.toString();
		if (str.trim().endsWith("/"))
			endpointURI = URI.create(str.substring(0, str.length() - 1));

		Logger.getLogger(SocketClientFactory.class).debug("Socket URL: " + endpointURI);
		ClientEndpoint endpoint = endpoints.get(endpointURI);
		if (endpoint == null || endpoint.isClosed()) {
			WebSocketContainer container = ContainerProvider.getWebSocketContainer();
//			container.setDefaultMaxTextMessageBufferSize(arg0);
			endpoint = new ClientEndpoint();
			container.connectToServer(endpoint, endpointURI);

			endpoints.put(endpointURI, endpoint);
		}
		return endpoint;
	}
}
