package ru.infor.websocket.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpointConfig;

import org.apache.log4j.Logger;

public class MyApplicationConfig implements ServerApplicationConfig {
	@Override
	public Set<ServerEndpointConfig> getEndpointConfigs(Set<Class<? extends Endpoint>> set) {
		Logger.getLogger(MyApplicationConfig.class).info("getEndpointConfigs: " + set);

		return new HashSet<ServerEndpointConfig>() {
			private static final long serialVersionUID = -5185096200972076898L;

			{
				add(ServerEndpointConfig.Builder.create(SocketEndpoint.class, "/socket").build());
			}
		};
	}

	@Override
	public Set<Class<?>> getAnnotatedEndpointClasses(Set<Class<?>> set) {
		return Collections.emptySet();
	}
}