package ru.infor.websocket.server;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.Future;

import org.apache.log4j.Logger;

import ru.infor.websocket.annotation.WebsocketService;

public final class SocketServerFactory {

	static Map<Class<?>, Object> map = new LinkedHashMap<Class<?>, Object>();

	private SocketServerFactory() {
		super();
	}

	public static <T> T get(Class<T> clazz, String sid) {
		if (sid != null && sid.trim().length() > 0)
			return (T) Proxy.newProxyInstance(SocketServerFactory.class.getClassLoader(), new Class[] { clazz },
					new Handler(clazz, sid));

		T res = null;
		synchronized (map) {
			res = (T) map.get(clazz);
			if (res != null)
				return res;

			res = (T) Proxy.newProxyInstance(SocketServerFactory.class.getClassLoader(), new Class[] { clazz },
					new Handler(clazz, null));

			map.put(clazz, res);

			return res;
		}
	}

	public static <T> T get(Class<T> clazz) {
		return get(clazz, null);
	}

}

class Handler implements InvocationHandler {

	private static final Logger logger = Logger.getLogger(Handler.class);

	String serviceName;

	String sid;

	protected Handler(Class<?> clazz, String sid) {
		super();

		serviceName = clazz.getAnnotation(WebsocketService.class).name();
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		List<Object> values = new ArrayList<Object>(0);
		if (args != null && args.length > 0) {
			Object tmp = args[0];
			logger.debug("method param 0: " + (tmp == null ? null : tmp.getClass().getName()));

			if (tmp != null) {
				if (tmp.getClass().isArray())
					values = Arrays.asList((Object[]) tmp);
				else if (Collection.class.isAssignableFrom(tmp.getClass()))
					values = new ArrayList<Object>((Collection<Object>) tmp);
			}
		}

		logger.debug("values to process: " + values.size());
		logger.debug("method.getReturnType(): " + method.getReturnType());
		if (method.getReturnType() == null || Void.class.equals(method.getReturnType())
				|| Void.TYPE.equals(method.getReturnType()))
			SocketEndpoint.notify(serviceName, method.getName(), sid, values);
		else {
			if (!Map.class.isAssignableFrom(method.getReturnType()))
				throw new RuntimeException("RPC method must return java.util.Map<String, ?>");

			Map<String, Future<?>> resp = SocketEndpoint.invoke(serviceName, method.getName(), sid, values);
			return resp;

			// Map<String, Object> resSync = new HashMap<String,
			// Object>(resp.size());
			// for (Entry<String, Future<?>> e : resp.entrySet()) {
			// while (!e.getValue().isDone())
			// try {
			// Thread.sleep(500L);
			// } catch (Exception exp) {
			// }
			//
			// resSync.put(e.getKey(), e.getValue().get());
			// }
			//
			// return resSync;
		}
		return null;
	}

}
