package ru.infor.websocket.transport;

import java.io.Serializable;
import java.util.Collection;

public abstract class SubscribingOptions<T> extends WSMessageWithContext implements Serializable {

	private static final long serialVersionUID = 6492170300929833731L;

	public abstract Collection<T> filter(Collection<T> col);
	
	// called on server when subscription is being opened
	public void afterSubscriptionOpened() {
		
	}
	
	// called on server when socket session is being closed
	public void afterSessionClosed() {
		
	}

}
