package ru.infor.websocket.transport;

import java.io.Serializable;

public class SubscribingResult extends WSMessage implements Serializable {

	private static final long serialVersionUID = 2954114518244833503L;

	private int status = 0; // 0 - ok
	private String errorMessage;

	public int getStatus() {
		return status;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	@Override
	public String toString() {
		return "SubscribingResult {status = " + status + ", errorMessage = " + errorMessage + "}";
	}

	public static SubscribingResult getSuccess() {
		SubscribingResult res = new SubscribingResult();
		res.status = 0; // OK

		return res;
	}

	public static SubscribingResult getError(String message) {
		SubscribingResult res = new SubscribingResult();
		res.status = -1; // KO
		res.errorMessage = message;

		return res;
	}
}
