package ru.infor.websocket.transport;

import java.io.Serializable;

public abstract class WSMessage implements Serializable {
	
	private static final long serialVersionUID = -3742272885686210760L;
	
	private String sid;
	private String serviceName;
	private String methodName;
	private String messageType = this.getClass().getName();
	
	public WSMessage() {
		super();
	}
	
	public WSMessage( WSMessage req) {
		super();
		
		this.sid = req.getSid();
		this.methodName = req.getMethodName();
		this.serviceName = req.getServiceName();
	}

	public String getServiceName() {
		return serviceName;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public String getMessageType() {
		return messageType;
	}

	public String getSid() {
		return sid;
	}

	public void setSid(String sid) {
		this.sid = sid;
	}

	@Override
	public String toString() {
		return "WSMessage [sid=" + sid + ", serviceName=" + serviceName + ", methodName=" + methodName + "]";
	}
	
	

}
